// ============================================================================
// COPYRIGHT NOTICE
// ----------------------------------------------------------------------------
// (This is the open source ISC license, see
// http://en.wikipedia.org/wiki/ISC_license
// for more info)
//
// Copyright © 2012-2024  Andreas M. Rammelt <rammi@caff.de>
//
// Permission to use, copy, modify, and/or distribute this software for any
// purpose with or without fee is hereby granted, provided that the above
// copyright notice and this permission notice appear in all copies.
//
// THE SOFTWARE IS PROVIDED "AS IS" AND THE AUTHOR DISCLAIMS ALL WARRANTIES
// WITH REGARD TO THIS SOFTWARE INCLUDING ALL IMPLIED WARRANTIES OF
// MERCHANTABILITY AND FITNESS. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR
// ANY SPECIAL, DIRECT, INDIRECT, OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
// WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN
// ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF
// OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
//=============================================================================
// Latest version on https://caff.de/projects/decaff-commons/
//=============================================================================
package de.caff.generics.converter;

import de.caff.generics.OrderedPair;
import de.caff.generics.function.Function1;

import java.util.Map;

/**
 * A map entry converter which converts the value type in a map.
 *
 * @author <a href="mailto:rammi@caff.de">Rammi</a>
 */
public class MapValueConverter<K, VT, VS>
  implements Function1<Map.Entry<K, VT>, Map.Entry<K, VS>>
{
  private final Function1<VT, VS> valueConverter;

  /**
   * Constructor.
   * @param valueConverter the value converter, used for changing the value
   */
  public MapValueConverter(Function1<VT, VS> valueConverter)
  {
    this.valueConverter = valueConverter;
  }

  /**
   * Convert an object to another type.
   *
   * @param object object to convert
   * @return target object
   */
  @Override
  public Map.Entry<K, VT> apply(Map.Entry<K, VS> object)
  {
    return OrderedPair.create(object.getKey(),
                              valueConverter.apply(object.getValue()));
  }
}
