// ============================================================================
// COPYRIGHT NOTICE
// ----------------------------------------------------------------------------
// (This is the open source ISC license, see
// http://en.wikipedia.org/wiki/ISC_license
// for more info)
//
// Copyright © 2012-2024  Andreas M. Rammelt <rammi@caff.de>
//
// Permission to use, copy, modify, and/or distribute this software for any
// purpose with or without fee is hereby granted, provided that the above
// copyright notice and this permission notice appear in all copies.
//
// THE SOFTWARE IS PROVIDED "AS IS" AND THE AUTHOR DISCLAIMS ALL WARRANTIES
// WITH REGARD TO THIS SOFTWARE INCLUDING ALL IMPLIED WARRANTIES OF
// MERCHANTABILITY AND FITNESS. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR
// ANY SPECIAL, DIRECT, INDIRECT, OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
// WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN
// ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF
// OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
//=============================================================================
// Latest version on https://caff.de/projects/decaff-commons/
//=============================================================================
package de.caff.generics.checker;

import de.caff.annotation.NotNull;
import de.caff.generics.function.Predicate1;

import java.util.function.Predicate;

/**
 * A wrapper for a checker which negates the results.
 * @author <a href="mailto:rammi@caff.de">Rammi</a>
 * @see Check#not(java.util.function.Predicate)
 */
public class NegateCheckerWrapper<T>
        implements Predicate1<T>
{
  @NotNull
  private final Predicate<T> wrapped;

  /**
   * Constructor.
   * @param wrapped the wrapped checker
   */
  public NegateCheckerWrapper(@NotNull Predicate<T> wrapped)
  {
    this.wrapped = wrapped;
  }

  /**
   * Check a value.
   *
   * @param value the value
   * @return {@code true}: the value is accepted<br>
   *         {@code false}: the value is not accepted
   */
  @Override
  public boolean test(T value)
  {
    return ! wrapped.test(value);
  }
}
