// ============================================================================
// COPYRIGHT NOTICE
// ----------------------------------------------------------------------------
// (This is the open source ISC license, see
// http://en.wikipedia.org/wiki/ISC_license
// for more info)
//
// Copyright © 2012-2024  Andreas M. Rammelt <rammi@caff.de>
//
// Permission to use, copy, modify, and/or distribute this software for any
// purpose with or without fee is hereby granted, provided that the above
// copyright notice and this permission notice appear in all copies.
//
// THE SOFTWARE IS PROVIDED "AS IS" AND THE AUTHOR DISCLAIMS ALL WARRANTIES
// WITH REGARD TO THIS SOFTWARE INCLUDING ALL IMPLIED WARRANTIES OF
// MERCHANTABILITY AND FITNESS. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR
// ANY SPECIAL, DIRECT, INDIRECT, OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
// WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN
// ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF
// OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
//=============================================================================
// Latest version on https://caff.de/projects/decaff-commons/
//=============================================================================
package de.caff.generics;

import de.caff.annotation.NotNull;

/**
 * Exception thrown during type conversion.
 * Basically it's just a wrapper around the exception which happened during the conversion.
 *
 * @author <a href="mailto:rammi@caff.de">Rammi</a>
 */
public class TypeConverterException
        extends Exception
{
  private static final long serialVersionUID = -2449568911370377498L;

  @NotNull
  private final Exception exception;

  /**
   * Constructor.
   *
   * @param cause the exception which caused the type conversion to fail
   */
  public TypeConverterException(@NotNull Exception cause)
  {
    super("Exception during type conversion!", cause);
    this.exception = cause;
  }

  /**
   * Get the exception which caused the type conversion to fail.
   * @return basic exception
   */
  @NotNull
  public Exception getException()
  {
    return exception;
  }
}
