// ============================================================================
// File:               Sizeable
//
// Project:            CAFF
//
// Purpose:            
//
// Author:             Rammi
//
// Copyright Notice:   © 2021-2024  Rammi (rammi@caff.de)
//                     The usage of this source code in commercial or open 
//                     source projects is not allowed without explicit 
//                     permission.
//
// Created:            05.12.21 16:42
//=============================================================================
package de.caff.generics;

/**
 * Something which has an integer size.

 * @author <a href="mailto:rammi@caff.de">Rammi</a>
 * @since December 05, 2021
 */
@FunctionalInterface // also other interfaces should be preferred, e.g. IntSupplier
public interface Sizeable
{
  Sizeable NULL = () -> 0;

  /**
   * Get the size.
   * Size is never negative.
   * @return the size of this object, usually the number of contained elements, must not be negative
   */
  int size();
}
