// ============================================================================
// File:               SingletonIterator
//
// Project:            CAFF
//
// Purpose:            
//
// Author:             Rammi
//
// Copyright Notice:   © 2021-2024  Rammi (rammi@caff.de)
//                     The usage of this source code in commercial or open 
//                     source projects is not allowed without explicit 
//                     permission.
//
// Created:            08.08.21 12:49
//=============================================================================
package de.caff.generics;

import java.util.Iterator;
import java.util.NoSuchElementException;

/**
 * An iterator which iterates over a single element.
 * @param <T> element type of iterator
 * @author <a href="mailto:rammi@caff.de">Rammi</a>
 * @since August 08, 2021
 */
public class SingletonIterator<T>
        implements Iterator<T>
{
  private final T element;
  private boolean finished;

  /**
   * Constructor.
   * @param element single element in this iterator
   */
  public SingletonIterator(T element)
  {
    this.element = element;
  }

  @Override
  public boolean hasNext()
  {
    return !finished;
  }

  @Override
  public T next()
  {
    if (finished) {
      throw new NoSuchElementException("Only 1 element in a singleton iterator!");
    }
    finished = true;
    return element;
  }
}
