// ============================================================================
// File:               LazyEvalutionFailure
//
// Project:            CAFF
//
// Purpose:            
//
// Author:             Rammi
//
// Copyright Notice:   © 2025  Rammi (rammi@caff.de)
//                     The usage of this source code in commercial or open 
//                     source projects is not allowed without explicit 
//                     permission.
//
// Created:            4/6/25 9:42 AM
//=============================================================================
package de.caff.generics;

import de.caff.annotation.NotNull;

/**
 * Exception thrown when a {@link Lazy lazy evaluation} fails
 * because of a checked exception.
 * @author <a href="mailto:rammi@caff.de">Rammi</a>
 * @since April 06, 2025
 */
public class LazyEvalutionFailure
        extends RuntimeException
{
  private static final long serialVersionUID = -5874803999688323855L;

  /**
   * Constructor.
   * @param cause cause of the lazy evaluation failure
   */
  public LazyEvalutionFailure(@NotNull Exception cause)
  {
    super("Lazy evaluation failed!", cause);
  }
}
