// ============================================================================
// COPYRIGHT NOTICE
// ----------------------------------------------------------------------------
// (This is the open source ISC license, see
// http://en.wikipedia.org/wiki/ISC_license
// for more info)
//
// Copyright © 2012-2024  Andreas M. Rammelt <rammi@caff.de>
//
// Permission to use, copy, modify, and/or distribute this software for any
// purpose with or without fee is hereby granted, provided that the above
// copyright notice and this permission notice appear in all copies.
//
// THE SOFTWARE IS PROVIDED "AS IS" AND THE AUTHOR DISCLAIMS ALL WARRANTIES
// WITH REGARD TO THIS SOFTWARE INCLUDING ALL IMPLIED WARRANTIES OF
// MERCHANTABILITY AND FITNESS. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR
// ANY SPECIAL, DIRECT, INDIRECT, OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
// WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN
// ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF
// OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
//=============================================================================
// Latest version on https://caff.de/projects/decaff-commons/
//=============================================================================
package de.caff.generics;

import de.caff.annotation.NotNull;

import java.util.Enumeration;
import java.util.Iterator;

/**
 * Enumeration wrapper for an iterator.
 * @author <a href="mailto:rammi@caff.de">Rammi</a>
 * @see de.caff.generics.Types#toEnumeration(java.util.Iterator) )
 */
public class IteratorEnumeration<T>
        implements Enumeration<T>
{
  @NotNull
  private final Iterator<T> iterator;

  /**
   * Constructor.
   * @param iterator the wrapped iterator
   */
  public IteratorEnumeration(@NotNull Iterator<T> iterator)
  {
    this.iterator = iterator;
  }

  /**
   * Tests if this enumeration contains more elements.
   *
   * @return {@code true} if and only if this enumeration object
   *         contains at least one more element to provide;
   *         {@code false} otherwise.
   */
  @Override
  public boolean hasMoreElements()
  {
    return iterator.hasNext();
  }

  /**
   * Returns the next element of this enumeration if this enumeration
   * object has at least one more element to provide.
   *
   * @return the next element of this enumeration.
   * @throws java.util.NoSuchElementException
   *          if no more elements exist.
   */
  @Override
  public T nextElement()
  {
    return iterator.next();
  }
}
