// ============================================================================
// COPYRIGHT NOTICE
// ----------------------------------------------------------------------------
// (This is the open source ISC license, see
// http://en.wikipedia.org/wiki/ISC_license
// for more info)
//
// Copyright © 2015-2024  Andreas M. Rammelt <rammi@caff.de>
//
// Permission to use, copy, modify, and/or distribute this software for any
// purpose with or without fee is hereby granted, provided that the above
// copyright notice and this permission notice appear in all copies.
//
// THE SOFTWARE IS PROVIDED "AS IS" AND THE AUTHOR DISCLAIMS ALL WARRANTIES
// WITH REGARD TO THIS SOFTWARE INCLUDING ALL IMPLIED WARRANTIES OF
// MERCHANTABILITY AND FITNESS. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR
// ANY SPECIAL, DIRECT, INDIRECT, OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
// WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN
// ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF
// OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
//=============================================================================
// Latest version on https://caff.de/projects/decaff-commons/
//=============================================================================
package de.caff.generics;

/**
 * This interface just contains various constant empty items (especially arrays):
 * These can be used as defaults in various circumstances.
 *
 * @author <a href="mailto:rammi@caff.de">Rammi</a>
 */
public final class Empty
{
  /** Empty {@link java.lang.String}. */
  public static final String STRING = "";

  // === primitive arrays ===
  /** Empty {@code boolean} array. */
  public static final boolean[] BOOLEAN_ARRAY = {};
  /** Empty {@code byte} array. */
  public static final byte[] BYTE_ARRAY = {};
  /** Empty {@code char} array. */
  public static final char[] CHAR_ARRAY = {};
  /** Empty {@code short} array, */
  public static final short[] SHORT_ARRAY = {};
  /** Empty {@code int} array, */
  public static final int[] INT_ARRAY = {};
  /** Empty {@code long} array, */
  public static final long[] LONG_ARRAY = {};
  /** Empty {@code float} array. */
  public static final float[] FLOAT_ARRAY = {};
  /** Empty {@code double} array. */
  public static final double[] DOUBLE_ARRAY = {};

  // === primitive 2D arrays ===
  /** Empty array of {@code boolean} arrays. */
  public static final boolean[][] BOOLEAN_ARRAY_2D = {};
  /** Empty array of {@code byte} arrays. */
  public static final byte[][] BYTE_ARRAY_2D = {};
  /** Empty array of {@code char} arrays. */
  public static final char[][] CHAR_ARRAY_2D = {};
  /** Empty array of {@code short} arrays, */
  public static final short[][] SHORT_ARRAY_2D = {};
  /** Empty array of {@code int} arrays, */
  public static final int[][] INT_ARRAY_2D = {};
  /** Empty array of {@code long} arrays, */
  public static final long[][] LONG_ARRAY_2D = {};
  /** Empty array of {@code float} arrays. */
  public static final float[][] FLOAT_ARRAY_2D = {};
  /** Empty array of {@code double} arrays. */
  public static final double[][] DOUBLE_ARRAY_2D = {};

  // === primitive wrapper arrays ===
  /** Emoty {@link java.lang.Boolean} array. */
  public static final Boolean[] CLASS_BOOLEAN_ARRAY = {};
  /** Empty {@link java.lang.Byte} array. */
  public static final Byte[] CLASS_BYTE_ARRAY = {};
  /** Empty {@link java.lang.Character} array. */
  public static final Character[] CLASS_CHAR_ARRAY = {};
  /** Empty {@link java.lang.Short} array, */
  public static final Short[] CLASS_SHORT_ARRAY = {};
  /** Empty {@link java.lang.Integer} array, */
  public static final Integer[] CLASS_INTEGER_ARRAY = {};
  /** Empty {@link java.lang.Long} array, */
  public static final Long[] CLASS_LONG_ARRAY = {};
  /** Empty {@link java.lang.Float} array. */
  public static final Float[] CLASS_FLOAT_ARRAY = {};
  /** Empty {@link java.lang.Double} array. */
  public static final Double[] CLASS_DOUBLE_ARRAY = {};

  // === Some common object arrays ===
  /** Empty {@link java.lang.Object} array. */
  public static final Object[] OBJECT_ARRAY = {};
  /** Empty {@link java.lang.String} array. */
  public static final String[] STRING_ARRAY = {};
  /** Empty {@link Number} array. */
  public static final Number[] NUMBER_ARRAY = {};

  // == Some common object 2D arrays, */
  /** Empty array of {@link java.lang.Object} arrays. */
  public static final Object[][] OBJECT_ARRAY_2D = {};
  /** Empty array of {@link java.lang.String} arrays. */
  public static final String[][] STRING_ARRAY_2D = {};
  /** Empty array of {@link java.lang.Number} arrays. */
  public static final Number[][] NUMBER_ARRAY_2D = {};

  /** Not constructable. */
  private Empty()
  {
  }
}
