// ============================================================================
// COPYRIGHT NOTICE
// ----------------------------------------------------------------------------
// (This is the open source ISC license, see
// http://en.wikipedia.org/wiki/ISC_license
// for more info)
//
// Copyright © 2012-2024  Andreas M. Rammelt <rammi@caff.de>
//
// Permission to use, copy, modify, and/or distribute this software for any
// purpose with or without fee is hereby granted, provided that the above
// copyright notice and this permission notice appear in all copies.
//
// THE SOFTWARE IS PROVIDED "AS IS" AND THE AUTHOR DISCLAIMS ALL WARRANTIES
// WITH REGARD TO THIS SOFTWARE INCLUDING ALL IMPLIED WARRANTIES OF
// MERCHANTABILITY AND FITNESS. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR
// ANY SPECIAL, DIRECT, INDIRECT, OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
// WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN
// ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF
// OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
//=============================================================================
// Latest version on https://caff.de/projects/decaff-commons/
//=============================================================================
package de.caff.generics;

import java.util.Set;

/**
 * A set which counts the number of additions.
 * <p>
 * Because it would be breaking the set semantics removal is not allowed.
 * All removal methods but {@link CountingHashSet#clear()}
 * therefore will throw an {@link UnsupportedOperationException}.
 *
 * @author <a href="mailto:rammi@caff.de">Rammi</a>
 * @param <T> set type
 */
public interface CountingSet<T>
        extends Set<T>
{
  /**
   * Get the count how often any item was added.
   * @param item item to look for
   * @return add count or {@code 0} if the item was never added
   *         (or the clear code has been used after its addition)
   */
  int getCount(T item);
}
