// ============================================================================
// COPYRIGHT NOTICE
// ----------------------------------------------------------------------------
// (This is the open source ISC license, see
// http://en.wikipedia.org/wiki/ISC_license
// for more info)
//
// Copyright © 2012-2024  Andreas M. Rammelt <rammi@caff.de>
//
// Permission to use, copy, modify, and/or distribute this software for any
// purpose with or without fee is hereby granted, provided that the above
// copyright notice and this permission notice appear in all copies.
//
// THE SOFTWARE IS PROVIDED "AS IS" AND THE AUTHOR DISCLAIMS ALL WARRANTIES
// WITH REGARD TO THIS SOFTWARE INCLUDING ALL IMPLIED WARRANTIES OF
// MERCHANTABILITY AND FITNESS. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR
// ANY SPECIAL, DIRECT, INDIRECT, OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
// WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN
// ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF
// OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
//=============================================================================
// Latest version on https://caff.de/projects/decaff-commons/
//=============================================================================

package de.caff.generics;

import de.caff.annotation.NotNull;
import de.caff.generics.util.Counter;
import de.caff.generics.util.SimpleCounter;

import java.util.HashMap;
import java.util.function.Supplier;

/**
 * A set which also counts how often any element was added.
 * <p>
 * Because it would be breaking the set semantics removal is not allowed.
 * All removal methods but {@link CountingHashSet#clear()}
 * therefore will throw an {@link UnsupportedOperationException}.
 *
 * @author <a href="mailto:rammi@caff.de">Rammi</a>
 */
public class CountingHashSet<T>
        extends AbstractBasicCountingSet<T>
{
  /**
   * Constructor.
   * @param creator counter creator used for counter creation,
   *                see {@link Counter#SIMPLE} or {@link Counter#THREAD_SAFE}
   *                for standard ones
   */
  public CountingHashSet(@NotNull Supplier<Counter> creator)
  {
    super(new HashMap<>(), creator);
  }

  /**
   * Constructor.
   * This will use {@link SimpleCounter simple counters}.
   */
  public CountingHashSet()
  {
    this(Counter.SIMPLE);
  }
}
