// ============================================================================
// COPYRIGHT NOTICE
// ----------------------------------------------------------------------------
// (This is the open source ISC license, see
// http://en.wikipedia.org/wiki/ISC_license
// for more info)
//
// Copyright © 2014-2024  Andreas M. Rammelt <rammi@caff.de>
//
// Permission to use, copy, modify, and/or distribute this software for any
// purpose with or without fee is hereby granted, provided that the above
// copyright notice and this permission notice appear in all copies.
//
// THE SOFTWARE IS PROVIDED "AS IS" AND THE AUTHOR DISCLAIMS ALL WARRANTIES
// WITH REGARD TO THIS SOFTWARE INCLUDING ALL IMPLIED WARRANTIES OF
// MERCHANTABILITY AND FITNESS. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR
// ANY SPECIAL, DIRECT, INDIRECT, OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
// WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN
// ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF
// OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
//=============================================================================
// Latest version on https://caff.de/projects/decaff-commons/
//=============================================================================
package de.caff.generics;

/**
 * A listener for {@link de.caff.generics.ActiveList active lists}.
 * <p>
 * In general a listener should not change the list during its
 * call.
 *
 * @param <T> list type
 * @author <a href="mailto:rammi@caff.de">Rammi</a>
 */
public interface ActiveListListener<T>
{
  /**
   * Called when an item was added.
   * @param index where item was added
   * @param item added item
   */
  void itemAdded(int index, T item);

  /**
   * Called when an item was removed.
   * @param index index which the item had before it was removed
   * @param item  removed item
   */
  void itemRemoved(int index, T item);

  /**
   * Called when an item was exchanged.
   * @param index    index where the exchange did happen
   * @param oldItem  old item which was removed
   * @param newItem  new item which was added
   */
  void itemExchanged(int index, T oldItem, T newItem);
}
