// ============================================================================
// COPYRIGHT NOTICE
// ----------------------------------------------------------------------------
// (This is the open source ISC license, see
// http://en.wikipedia.org/wiki/ISC_license
// for more info)
//
// Copyright © 2012-2024  Andreas M. Rammelt <rammi@caff.de>
//
// Permission to use, copy, modify, and/or distribute this software for any
// purpose with or without fee is hereby granted, provided that the above
// copyright notice and this permission notice appear in all copies.
//
// THE SOFTWARE IS PROVIDED "AS IS" AND THE AUTHOR DISCLAIMS ALL WARRANTIES
// WITH REGARD TO THIS SOFTWARE INCLUDING ALL IMPLIED WARRANTIES OF
// MERCHANTABILITY AND FITNESS. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR
// ANY SPECIAL, DIRECT, INDIRECT, OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
// WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN
// ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF
// OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
//=============================================================================
// Latest version on https://caff.de/projects/decaff-commons/
//=============================================================================
package de.caff.generics;

import de.caff.annotation.NotNull;

import java.util.Collection;
import java.util.List;

/**
 * Basic implementation of an unmodifiable list.
 * @author <a href="mailto:rammi@caff.de">Rammi</a>
 */
public abstract class AbstractBasicUnmodifiableList<T>
        implements List<T>
{
  /**
   * Removes all of the elements from this list (optional operation).  This
   * list will be empty after this call returns (unless it throws an
   * exception).
   *
   * @throws UnsupportedOperationException if the <tt>clear</tt> method is
   *                                       not supported by this list.
   */
  @Override
  public void clear()
  {
    throw new UnsupportedOperationException();
  }

  /**
   * Removes the element at the specified position in this list (optional
   * operation).  Shifts any subsequent elements to the left (subtracts one
   * from their indices).  Returns the element that was removed from the
   * list.
   *
   * @param index the index of the element to removed.
   * @return the element previously at the specified position.
   * @throws UnsupportedOperationException if the <tt>remove</tt> method is
   *                                       not supported by this list.
   * @throws IndexOutOfBoundsException     if the index is out of range (index
   *                                       &lt; 0 || index &gt;= size()).
   */
  @Override
  public T remove(int index)
  {
    throw new UnsupportedOperationException();
  }

  /**
   * Removes the first occurrence in this list of the specified element
   * (optional operation).  If this list does not contain the element, it is
   * unchanged.  More formally, removes the element with the lowest index i
   * such that <tt>(o==null ? get(i)==null : o.equals(get(i)))</tt> (if
   * such an element exists).
   *
   * @param o element to be removed from this list, if present.
   * @return <tt>true</tt> if this list contained the specified element.
   * @throws ClassCastException            if the type of the specified element
   *                                       is incompatible with this list (optional).
   * @throws NullPointerException          if the specified element is null and this
   *                                       list does not support null elements (optional).
   * @throws UnsupportedOperationException if the <tt>remove</tt> method is
   *                                       not supported by this list.
   */
  @Override
  public boolean remove(Object o)
  {
    throw new UnsupportedOperationException();
  }

  /**
   * Inserts all of the elements in the specified collection into this
   * list at the specified position (optional operation).  Shifts the
   * element currently at that position (if any) and any subsequent
   * elements to the right (increases their indices).  The new elements
   * will appear in this list in the order that they are returned by the
   * specified collection's iterator.  The behavior of this operation is
   * unspecified if the specified collection is modified while the
   * operation is in progress.  (Note that this will occur if the specified
   * collection is this list, and it's nonempty.)
   *
   * @param index index at which to insert first element from the specified
   *              collection.
   * @param c     elements to be inserted into this list.
   * @return <tt>true</tt> if this list changed as a result of the call.
   * @throws UnsupportedOperationException if the <tt>addAll</tt> method is
   *                                       not supported by this list.
   * @throws ClassCastException            if the class of one of elements of the
   *                                       specified collection prevents it from being added to this
   *                                       list.
   * @throws NullPointerException          if the specified collection contains one
   *                                       or more null elements and this list does not support null
   *                                       elements, or if the specified collection is <tt>null</tt>.
   * @throws IllegalArgumentException      if some aspect of one of elements of
   *                                       the specified collection prevents it from being added to
   *                                       this list.
   * @throws IndexOutOfBoundsException     if the index is out of range (index
   *                                       &lt; 0 || index &gt; size()).
   */
  @Override
  public boolean addAll(int index, @NotNull Collection<? extends T> c)
  {
    throw new UnsupportedOperationException();
  }

  /**
   * Appends all of the elements in the specified collection to the end of
   * this list, in the order that they are returned by the specified
   * collection's iterator (optional operation).  The behavior of this
   * operation is unspecified if the specified collection is modified while
   * the operation is in progress.  (Note that this will occur if the
   * specified collection is this list, and it's nonempty.)
   *
   * @param c collection whose elements are to be added to this list.
   * @return <tt>true</tt> if this list changed as a result of the call.
   * @throws UnsupportedOperationException if the <tt>addAll</tt> method is
   *                                       not supported by this list.
   * @throws ClassCastException            if the class of an element in the specified
   *                                       collection prevents it from being added to this list.
   * @throws NullPointerException          if the specified collection contains one
   *                                       or more null elements and this list does not support null
   *                                       elements, or if the specified collection is <tt>null</tt>.
   * @throws IllegalArgumentException      if some aspect of an element in the
   *                                       specified collection prevents it from being added to this
   *                                       list.
   * @see #add(Object)
   */
  @Override
  @SuppressWarnings("rawtypes")
  public boolean addAll(@NotNull Collection c)
  {
    throw new UnsupportedOperationException();
  }

  /**
   * Removes from this list all the elements that are contained in the
   * specified collection (optional operation).
   *
   * @param c collection that defines which elements will be removed from
   *          this list.
   * @return <tt>true</tt> if this list changed as a result of the call.
   * @throws UnsupportedOperationException if the <tt>removeAll</tt> method
   *                                       is not supported by this list.
   * @throws ClassCastException            if the types of one or more elements
   *                                       in this list are incompatible with the specified
   *                                       collection (optional).
   * @throws NullPointerException          if this list contains one or more
   *                                       null elements and the specified collection does not support
   *                                       null elements (optional).
   *                                       or if the specified collection is
   *                                       <tt>null</tt>.
   * @see #remove(Object)
   * @see #contains(Object)
   */
  @Override
  @SuppressWarnings("rawtypes")
  public boolean removeAll(@NotNull Collection c)
  {
    throw new UnsupportedOperationException();
  }

  /**
   * Retains only the elements in this list that are contained in the
   * specified collection (optional operation).  In other words, removes
   * from this list all the elements that are not contained in the specified
   * collection.
   *
   * @param c collection that defines which elements this set will retain.
   * @return <tt>true</tt> if this list changed as a result of the call.
   * @throws UnsupportedOperationException if the <tt>retainAll</tt> method
   *                                       is not supported by this list.
   * @throws ClassCastException            if the types of one or more elements
   *                                       in this list are incompatible with the specified
   *                                       collection (optional).
   * @throws NullPointerException          if this list contains one or more
   *                                       null elements and the specified collection does not support
   *                                       null elements (optional).
   *                                       or if the specified collection is
   *                                       <tt>null</tt>.
   * @see #remove(Object)
   * @see #contains(Object)
   */
  @Override
  @SuppressWarnings("rawtypes")
  public boolean retainAll(@NotNull Collection c)
  {
    throw new UnsupportedOperationException();
  }

  /**
   * Replaces the element at the specified position in this list with the
   * specified element (optional operation).
   *
   * @param index   index of element to replace.
   * @param element element to be stored at the specified position.
   * @return the element previously at the specified position.
   * @throws UnsupportedOperationException if the <tt>set</tt> method is not
   *                                       supported by this list.
   * @throws ClassCastException            if the class of the specified element
   *                                       prevents it from being added to this list.
   * @throws NullPointerException          if the specified element is null and
   *                                       this list does not support null elements.
   * @throws IllegalArgumentException      if some aspect of the specified
   *                                       element prevents it from being added to this list.
   * @throws IndexOutOfBoundsException     if the index is out of range
   *                                       (index &lt; 0 || index &gt;= size()).
   */
  @Override
  public T set(int index, T element)
  {
    throw new UnsupportedOperationException();
  }

  /**
   * Inserts the specified element at the specified position in this list
   * (optional operation).  Shifts the element currently at that position
   * (if any) and any subsequent elements to the right (adds one to their
   * indices).
   *
   * @param index   index at which the specified element is to be inserted.
   * @param element element to be inserted.
   * @throws UnsupportedOperationException if the <tt>add</tt> method is not
   *                                       supported by this list.
   * @throws ClassCastException            if the class of the specified element
   *                                       prevents it from being added to this list.
   * @throws NullPointerException          if the specified element is null and
   *                                       this list does not support null elements.
   * @throws IllegalArgumentException      if some aspect of the specified
   *                                       element prevents it from being added to this list.
   * @throws IndexOutOfBoundsException     if the index is out of range
   *                                       (index &lt; 0 || index &gt; size()).
   */
  @Override
  public void add(int index, T element)
  {
    throw new UnsupportedOperationException();
  }

  /**
   * Appends the specified element to the end of this list (optional
   * operation). <p>
   *
   * Lists that support this operation may place limitations on what
   * elements may be added to this list.  In particular, some
   * lists will refuse to add null elements, and others will impose
   * restrictions on the type of elements that may be added.  List
   * classes should clearly specify in their documentation any restrictions
   * on what elements may be added.
   *
   * @param o element to be appended to this list.
   * @return <tt>true</tt> (as per the general contract of the
   *         <tt>Collection.add</tt> method).
   * @throws UnsupportedOperationException if the <tt>add</tt> method is not
   *                                       supported by this list.
   * @throws ClassCastException            if the class of the specified element
   *                                       prevents it from being added to this list.
   * @throws NullPointerException          if the specified element is null and this
   *                                       list does not support null elements.
   * @throws IllegalArgumentException      if some aspect of this element
   *                                       prevents it from being added to this list.
   */
  @Override
  public boolean add(T o)
  {
    throw new UnsupportedOperationException();
  }
}
