// ============================================================================
// COPYRIGHT NOTICE
// ----------------------------------------------------------------------------
// (This is the open source ISC license, see
// http://en.wikipedia.org/wiki/ISC_license
// for more info)
//
// Copyright © 2016-2024  Andreas M. Rammelt <rammi@caff.de>
//
// Permission to use, copy, modify, and/or distribute this software for any
// purpose with or without fee is hereby granted, provided that the above
// copyright notice and this permission notice appear in all copies.
//
// THE SOFTWARE IS PROVIDED "AS IS" AND THE AUTHOR DISCLAIMS ALL WARRANTIES
// WITH REGARD TO THIS SOFTWARE INCLUDING ALL IMPLIED WARRANTIES OF
// MERCHANTABILITY AND FITNESS. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR
// ANY SPECIAL, DIRECT, INDIRECT, OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
// WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN
// ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF
// OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
//=============================================================================
// Latest version on https://caff.de/projects/decaff-commons/
//=============================================================================
package de.caff.util.xml;

import de.caff.annotation.NotNull;

/**
 * A string collector which combines all strings it gets into a single text.
 * @author <a href="mailto:rammi@caff.de">Rammi</a>
 * @deprecated use the classes in the package {@link de.caff.io} and {@link de.caff.io.xml} instead.
 */
@Deprecated
public class TextStringCollector
        implements StringCollector
{
  /** Default initial size for string builder. */
  public static final int DEFAULT_INITIAL_SIZE = 0x10000;
  @NotNull
  private final StringBuilder sb;

  /**
   * Constructor.
   * This will create an internal string builder with
   * [@link {@link #DEFAULT_INITIAL_SIZE default initial size}.
   */
  public TextStringCollector()
  {
    this(DEFAULT_INITIAL_SIZE);
  }

  /**
   * Constructor.
   * This will create an internal string builder with
   * the given inital size.
   * @param initialSize  initial size, needs to be larger than zero
   */
  public TextStringCollector(int initialSize)
  {
    this(new StringBuilder(initialSize));
  }

  /**
   * Constructor.
   * @param sb string builder to which all collected texts are appended.
   */
  public TextStringCollector(@NotNull StringBuilder sb)
  {
    this.sb = sb;
  }

  /**
   * Add a string t this collector.
   *
   * @param str string collector
   */
  @Override
  public void add(@NotNull String str)
  {
    sb.append(str);
  }

  /**
   * Add a character to this collector.
   *
   * @param ch character to add
   */
  @Override
  public void add(char ch)
  {
    sb.append(ch);
  }

  /**
   * Get the last letter of the last string which was added.
   *
   * @return last letter, zero at the very beginning
   */
  @Override
  public char getLastLetter()
  {
    final int len = sb.length();
    return len > 0
            ? sb.charAt(len - 1)
            : '\0';
  }

  /**
   * Get the collected text.
   * @return collected text
   */
  public String getText()
  {
    return sb.toString();
  }
}
