// ============================================================================
// COPYRIGHT NOTICE
// ----------------------------------------------------------------------------
// (This is the open source ISC license, see
// http://en.wikipedia.org/wiki/ISC_license
// for more info)
//
// Copyright © 2016-2024  Andreas M. Rammelt <rammi@caff.de>
//
// Permission to use, copy, modify, and/or distribute this software for any
// purpose with or without fee is hereby granted, provided that the above
// copyright notice and this permission notice appear in all copies.
//
// THE SOFTWARE IS PROVIDED "AS IS" AND THE AUTHOR DISCLAIMS ALL WARRANTIES
// WITH REGARD TO THIS SOFTWARE INCLUDING ALL IMPLIED WARRANTIES OF
// MERCHANTABILITY AND FITNESS. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR
// ANY SPECIAL, DIRECT, INDIRECT, OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
// WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN
// ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF
// OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
//=============================================================================
// Latest version on https://caff.de/projects/decaff-commons/
//=============================================================================
package de.caff.util.xml;

import de.caff.annotation.NotNull;

/**
 * Collector for strings.
 * @author <a href="mailto:rammi@caff.de">Rammi</a>
 * @deprecated use the classes in the package {@link de.caff.io} and {@link de.caff.io.xml} instead.
 */
@Deprecated
public interface StringCollector
{
  /**
   * Add a string to this collector.
   * @param str string to add
   */
  void add(@NotNull String str);

  /**
   * Add a character to this collector.
   * @param ch character to add
   */
  void add(char ch);

  /**
   * Get the last letter of the last string which was added.
   * @return last letter, zero at the very beginning
   */
  char getLastLetter();
}
