//=============================================================================
// COPYRIGHT NOTICE
// ----------------------------------------------------------------------------
// (This is the open source ISC license, see
// http://en.wikipedia.org/wiki/ISC_license
// for more info)
//
// Copyright © 2010-2024  Andreas M. Rammelt <rammi@caff.de>
//
// Permission to use, copy, modify, and/or distribute this software for any
// purpose with or without fee is hereby granted, provided that the above
// copyright notice and this permission notice appear in all copies.
//
// THE SOFTWARE IS PROVIDED "AS IS" AND THE AUTHOR DISCLAIMS ALL WARRANTIES
// WITH REGARD TO THIS SOFTWARE INCLUDING ALL IMPLIED WARRANTIES OF
// MERCHANTABILITY AND FITNESS. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR
// ANY SPECIAL, DIRECT, INDIRECT, OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
// WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN
// ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF
// OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
//=============================================================================
// Latest version on https://caff.de/projects/decaff-commons/
//=============================================================================
package de.caff.util.measure;

import java.util.ListResourceBundle;

/**
 * Default (english) resource bundle.
 * @author <a href="mailto:rammi@caff.de">Rammi</a>
 */
public class UtilMeasureResourceBundle
        extends ListResourceBundle
{
  /**
   * See class description.
   */
  @Override
  protected Object[][] getContents()
  {
    return content;
  }

  private static final Object[][] content = {
          { SIPrefix.I18N_PREFIX + SIPrefix.DECI,   "deci" },
          { SIPrefix.I18N_PREFIX + SIPrefix.CENTI,  "centi" },
          { SIPrefix.I18N_PREFIX + SIPrefix.MILLI,  "milli" },
          { SIPrefix.I18N_PREFIX + SIPrefix.MICRO,  "micro" },
          { SIPrefix.I18N_PREFIX + SIPrefix.NANO,   "nano" },
          { SIPrefix.I18N_PREFIX + SIPrefix.PICO,   "pico" },
          { SIPrefix.I18N_PREFIX + SIPrefix.FEMTO,  "femto" },
          { SIPrefix.I18N_PREFIX + SIPrefix.ATTO,   "atto" },
          { SIPrefix.I18N_PREFIX + SIPrefix.ZEPTO,  "zepto" },
          { SIPrefix.I18N_PREFIX + SIPrefix.YOCTO,  "yocto" },
          { SIPrefix.I18N_PREFIX + SIPrefix.RONTO,  "ronto" },
          { SIPrefix.I18N_PREFIX + SIPrefix.QUECTO, "quecto" },

          { SIPrefix.I18N_PREFIX + SIPrefix.DECA,   "deca" },
          { SIPrefix.I18N_PREFIX + SIPrefix.HECTO,  "hecto" },
          { SIPrefix.I18N_PREFIX + SIPrefix.KILO,   "kilo" },
          { SIPrefix.I18N_PREFIX + SIPrefix.MEGA,   "mega" },
          { SIPrefix.I18N_PREFIX + SIPrefix.GIGA,   "giga" },
          { SIPrefix.I18N_PREFIX + SIPrefix.TERA,   "tera" },
          { SIPrefix.I18N_PREFIX + SIPrefix.PETA,   "peta" },
          { SIPrefix.I18N_PREFIX + SIPrefix.EXA,    "exa" },
          { SIPrefix.I18N_PREFIX + SIPrefix.ZETTA,  "zetta" },
          { SIPrefix.I18N_PREFIX + SIPrefix.YOTTA,  "yotta" },
          { SIPrefix.I18N_PREFIX + SIPrefix.RONNA,  "ronna" },
          { SIPrefix.I18N_PREFIX + SIPrefix.QUETTA, "quetta" },

          { SIPrefix.I18N_PREFIX + SIPrefix.KIBI,   "kibi" },
          { SIPrefix.I18N_PREFIX + SIPrefix.MEBI,   "mebi" },
          { SIPrefix.I18N_PREFIX + SIPrefix.GIBI,   "gibi" },
          { SIPrefix.I18N_PREFIX + SIPrefix.TEBI,   "tebi" },
          { SIPrefix.I18N_PREFIX + SIPrefix.PEBI,   "pebi" },
          { SIPrefix.I18N_PREFIX + SIPrefix.EXBI,   "exbi" },
          { SIPrefix.I18N_PREFIX + SIPrefix.ZEBI,   "zebi" },
          { SIPrefix.I18N_PREFIX + SIPrefix.YOBI,   "yobi" },
  };
}
