// ============================================================================
// COPYRIGHT NOTICE
// ----------------------------------------------------------------------------
// (This is the open source ISC license, see
// http://en.wikipedia.org/wiki/ISC_license
// for more info)
//
// Copyright © 1999-2024  Andreas M. Rammelt <rammi@caff.de>
//
// Permission to use, copy, modify, and/or distribute this software for any
// purpose with or without fee is hereby granted, provided that the above
// copyright notice and this permission notice appear in all copies.
//
// THE SOFTWARE IS PROVIDED "AS IS" AND THE AUTHOR DISCLAIMS ALL WARRANTIES
// WITH REGARD TO THIS SOFTWARE INCLUDING ALL IMPLIED WARRANTIES OF
// MERCHANTABILITY AND FITNESS. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR
// ANY SPECIAL, DIRECT, INDIRECT, OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
// WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN
// ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF
// OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
//=============================================================================
// Latest version on https://caff.de/projects/decaff-commons/
//=============================================================================

package de.caff.util.debug;

/**
 *  This interface is defined as a collection of constants used for debugging.
 */
public interface DebugConstants {
  /** no debugging mask */
  long NO_DEBUG_MASK  = 0x00000000;
  /** trace messages  */
  int  TRACE          = 0;
  /** trace messages flag */
  @SuppressWarnings("PointlessBitwiseExpression")
  long TRACE_FLAG     = 0x00000001L << TRACE;
  /** trace message shortcut */
  char TRACE_CHAR     = 'T';
  /** normal messages */
  int  MESSAGE        = TRACE+1;
  /** normal messages flag */
  long MESSAGE_FLAG   = 0x00000001L << MESSAGE;
  /** standard message shortcut */
  char MESSAGE_CHAR   = 'S';
  /** warning messages */
  int  WARNING        = MESSAGE+1;
  /** warning messages flag */
  long WARNING_FLAG   = 0x00000001L << WARNING;
  /** warning message shortcut */
  char WARNING_CHAR   = 'W';
  /** error messages */
  int  ERROR          = WARNING+1;
  /** error messages flag */
  long ERROR_FLAG     = 0x00000001L << ERROR;
  /** error message shortcut */
  char ERROR_CHAR     = 'E';
  /** fatal error messages */
  int  FATAL          = ERROR+1;
  /** fatal error messages flag */
  long FATAL_FLAG     = 0x00000001L << FATAL;
  /** fatal message shortcut */
  char FATAL_CHAR     = 'F';
  /** logging messages */
  int  LOG            = FATAL+1;
  /** logging messages flag */
  long LOG_FLAG       = 0x00000001L << LOG;
  /** logging message shortcut */
  char LOG_CHAR       = 'L';
  /** assertions */
  int  ASSERT         = LOG+1;
  /** assertions flag */
  long ASSERT_FLAG    = 0x00000001L << ASSERT;
  /** assertions shortcut */
  char ASSERT_CHAR    = 'A';
  /** All debug types. */
  int  NR_DEBUG_TYPES = ASSERT+1;
  /** all messages mask */
  long DEBUG_ALL_MASK = (0x00000001L << NR_DEBUG_TYPES)-1;
}
