// ============================================================================
// COPYRIGHT NOTICE
// ----------------------------------------------------------------------------
// (This is the open source ISC license, see
// http://en.wikipedia.org/wiki/ISC_license
// for more info)
//
// Copyright © 2015-2024  Andreas M. Rammelt <rammi@caff.de>
//
// Permission to use, copy, modify, and/or distribute this software for any
// purpose with or without fee is hereby granted, provided that the above
// copyright notice and this permission notice appear in all copies.
//
// THE SOFTWARE IS PROVIDED "AS IS" AND THE AUTHOR DISCLAIMS ALL WARRANTIES
// WITH REGARD TO THIS SOFTWARE INCLUDING ALL IMPLIED WARRANTIES OF
// MERCHANTABILITY AND FITNESS. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR
// ANY SPECIAL, DIRECT, INDIRECT, OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
// WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN
// ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF
// OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
//=============================================================================
// Latest version on https://caff.de/projects/decaff-commons/
//=============================================================================

/**
 * Helper classes for multi-threading.
 * <ul>
 *   <li>{@link de.caff.util.concurrent.Exec} provides helpful methods for thread pools.</li>
 *   <li>{@link de.caff.util.concurrent.ParallelSort} implements a parallel sorting algorithm of dubious value.</li>
 *   <li>
 *     {@link de.caff.util.concurrent.PresentFuture} is useful if a {@link java.util.concurrent.Future}
 *     is expected, but its value is already known.
 *   </li>
 *   <li>
 *     {@link de.caff.util.concurrent.PriorityExecutor} is helpful if you want to have the possibility to run some
 *     tasks faster.
 *   </li>
 * </ul>
 */
package de.caff.util.concurrent;
