//=============================================================================
// COPYRIGHT NOTICE
// ----------------------------------------------------------------------------
// (This is the open source ISC license, see
// http://en.wikipedia.org/wiki/ISC_license
// for more info)
//
// Copyright © 2005-2024  Andreas M. Rammelt <rammi@caff.de>
//
// Permission to use, copy, modify, and/or distribute this software for any
// purpose with or without fee is hereby granted, provided that the above
// copyright notice and this permission notice appear in all copies.
//
// THE SOFTWARE IS PROVIDED "AS IS" AND THE AUTHOR DISCLAIMS ALL WARRANTIES
// WITH REGARD TO THIS SOFTWARE INCLUDING ALL IMPLIED WARRANTIES OF
// MERCHANTABILITY AND FITNESS. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR
// ANY SPECIAL, DIRECT, INDIRECT, OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
// WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN
// ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF
// OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
//=============================================================================
// Latest version on https://caff.de/projects/decaff-commons/
//=============================================================================

package de.caff.util.args;

import de.caff.annotation.NotNull;

/**
 * Exception thrown if an unknown switch was encountered on the command line.
 * @author <a href="mailto:rammi@caff.de">Rammi</a>
 * @since January 27, 2019
 */
public class UnknownSwitchException
  extends Exception
{
  private static final long serialVersionUID = 5192178097599128895L;
  @NotNull
  private final String unknownSwitch;

  /**
   * Constructor.
   * @param unknownSwitch unknown switch encountered on the command line
   */
  public UnknownSwitchException(@NotNull String unknownSwitch)
  {
    super(String.format("Unknown switch %s found on command line!", unknownSwitch));
    this.unknownSwitch = unknownSwitch;
  }

  /**
   * Get the unknown switch encounterd on the command line.
   * @return unknown switch
   */
  @NotNull
  public String getUnknownSwitch()
  {
    return unknownSwitch;
  }
}
