// COPYRIGHT NOTICE
// ----------------------------------------------------------------------------
// (This is the open source ISC license, see
// http://en.wikipedia.org/wiki/ISC_license
// for more info)
//
// Copyright © 2005-2024  Andreas M. Rammelt <rammi@caff.de>
//
// Permission to use, copy, modify, and/or distribute this software for any
// purpose with or without fee is hereby granted, provided that the above
// copyright notice and this permission notice appear in all copies.
//
// THE SOFTWARE IS PROVIDED "AS IS" AND THE AUTHOR DISCLAIMS ALL WARRANTIES
// WITH REGARD TO THIS SOFTWARE INCLUDING ALL IMPLIED WARRANTIES OF
// MERCHANTABILITY AND FITNESS. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR
// ANY SPECIAL, DIRECT, INDIRECT, OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
// WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN
// ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF
// OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
//=============================================================================
// Latest version on https://caff.de/projects/decaff-commons/
//=============================================================================
package de.caff.util.args;

import de.caff.annotation.NotNull;
import de.caff.generics.Empty;
import de.caff.generics.Types;

import java.util.Collection;

/**
 * Thrown if too many arguments are given on the command line.
 * @author <a href="mailto:rammi@caff.de">Rammi</a>
 * @since January 27, 2019
 */
public class TooManyArgumentsException
        extends Exception
{
  private static final long serialVersionUID = 2810633983097225681L;

  @NotNull
  private final String arguments;

  public TooManyArgumentsException(@NotNull String argument,
                                   @NotNull Collection<String> furtherArguments)
  {
    this(argument + combine(furtherArguments));

  }

  private TooManyArgumentsException(@NotNull String combined)
  {
    super("There are surplus arguments: "+combined);
    arguments = combined;
  }

  @NotNull
  private static String combine(@NotNull Collection<String> arguments)
  {
    if (arguments.isEmpty()) {
      return Empty.STRING;
    }
    else {
      return " " + Types.join(" ", arguments);
    }
  }

  /**
   * Get the arguments.
   * @return combined arguments
   */
  @NotNull
  public String getArguments()
  {
    return arguments;
  }
}
