// ============================================================================
// File:               MultipleStringArgSwitch
//
// Project:            CAFF
//
// Purpose:            
//
// Author:             Rammi
//
// Copyright Notice:   © 2025  Rammi (rammi@caff.de)
//                     The usage of this source code in commercial or open 
//                     source projects is not allowed without explicit 
//                     permission.
//
// Created:            3/16/25 4:45 PM
//=============================================================================
package de.caff.util.args;

import de.caff.annotation.NotNull;
import de.caff.generics.Countable;
import de.caff.generics.Indexable;

import java.util.Collection;
import java.util.LinkedList;

import static de.caff.util.args.CommandLine.NON_BREAKING_SPACE;

/**
 * @author <a href="mailto:rammi@caff.de">Rammi</a>
 * @since March 16, 2025
 */
public class StringArgMultipleSwitch
  extends AbstractMultipleSwitch
{
  private final String argName;
  @NotNull
  private final Collection<String> parameters = new LinkedList<>();

  public StringArgMultipleSwitch(@NotNull Character shortForm,
                                 @NotNull String longForm,
                                 @NotNull String argName,
                                 @NotNull String description, int minCount)
  {
    this(shortForm, longForm, argName, description, minCount, Integer.MAX_VALUE);
  }

  public StringArgMultipleSwitch(@NotNull Character shortForm,
                                 @NotNull String longForm,
                                 @NotNull String argName,
                                 @NotNull String description, int minCount, int maxCount)
  {
    super(shortForm, longForm, description, minCount, maxCount);
    this.argName = argName;
  }

  @Override
  public boolean isVarLength() {
    return false; // the switch might appear several times, but it only consumes one argument
  }

  @Override
  public boolean needsArguments()
  {
    return true;
  }

  @Override
  public boolean consumeArgument(@NotNull String arg)
  {
    parameters.add(arg);
    return false; // no more args
  }

  @Override
  public void found(char shortSwitch)
  {
  }

  @Override
  public void found(@NotNull String longSwitch)
  {
  }

  @NotNull
  @Override
  public String getAppearance()
  {
    // return String.format("-%s"+NON_BREAKING_SPACE+"<%s>|--%s=<%s>", shortForm, argName, longForm, argName);
    final String single = String.format("-%s" + NON_BREAKING_SPACE + "<%s>|--%s=<%s>",
                                        shortForm, argName, longForm, argName);
    final StringBuilder appearance = new StringBuilder();
    for (int i = 0;  i < minCount;  ++i) {
      appearance.append(single);
    }
    appearance.append("[").append(single).append("]*");

    return appearance.toString();
  }

  @NotNull
  public Indexable<String> getParameters()
  {
    return Indexable.fromCollection(parameters);
  }
}
