// COPYRIGHT NOTICE
// ----------------------------------------------------------------------------
// (This is the open source ISC license, see
// http://en.wikipedia.org/wiki/ISC_license
// for more info)
//
// Copyright © 2005-2024  Andreas M. Rammelt <rammi@caff.de>
//
// Permission to use, copy, modify, and/or distribute this software for any
// purpose with or without fee is hereby granted, provided that the above
// copyright notice and this permission notice appear in all copies.
//
// THE SOFTWARE IS PROVIDED "AS IS" AND THE AUTHOR DISCLAIMS ALL WARRANTIES
// WITH REGARD TO THIS SOFTWARE INCLUDING ALL IMPLIED WARRANTIES OF
// MERCHANTABILITY AND FITNESS. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR
// ANY SPECIAL, DIRECT, INDIRECT, OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
// WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN
// ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF
// OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
//=============================================================================
// Latest version on https://caff.de/projects/decaff-commons/
//=============================================================================
package de.caff.util.args;

/**
 * A command line argument which is not a switch.
 * @author <a href="mailto:rammi@caff.de">Rammi</a>
 * @since January 27, 2019
 */
public interface Argument
        extends SwitchOrArgument
{
  /** Format for arguments. */
  String ARGUMENT_FORMAT = "<%s>";

  /**
   * Get the minimum number of times this argument might appear on the command line.
   * The default implementation returns {@code 1}.
   * @return minimum number of appearances of this argument
   */
  default int getMinimalCount()
  {
    return 1;
  }

  /**
   * Get the maximum number of times this argument might appear on the command line.
   * The default implementation returns the value of {@link #getMinimalCount()}
   * @return maximum number of appearances of this argument, use {@link Integer#MAX_VALUE}
   *         for infinity
   */
  default int getMaximalCount()
  {
    return getMinimalCount();
  }

  /**
   * Default implementation which returns {@code false}.
   * @return {@code false}
   */
  @Override
  default boolean isSwitch()
  {
    return false;
  }

  /**
   * Default implementation which used the {@link #getMinimalCount() minimal count}
   * to decide whether this is optional.
   * @return {@code true} when minimal count is {@code 0}, <br>
   *         {@code false} otherwise
   */
  @Override
  default boolean isOptional()
  {
    return false;
  }
}
