//=============================================================================
// COPYRIGHT NOTICE
// ----------------------------------------------------------------------------
// (This is the open source ISC license, see
// http://en.wikipedia.org/wiki/ISC_license
// for more info)
//
// Copyright © 2005-2024  Andreas M. Rammelt <rammi@caff.de>
//
// Permission to use, copy, modify, and/or distribute this software for any
// purpose with or without fee is hereby granted, provided that the above
// copyright notice and this permission notice appear in all copies.
//
// THE SOFTWARE IS PROVIDED "AS IS" AND THE AUTHOR DISCLAIMS ALL WARRANTIES
// WITH REGARD TO THIS SOFTWARE INCLUDING ALL IMPLIED WARRANTIES OF
// MERCHANTABILITY AND FITNESS. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR
// ANY SPECIAL, DIRECT, INDIRECT, OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
// WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN
// ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF
// OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
//=============================================================================
// Latest version on https://caff.de/projects/decaff-commons/
//=============================================================================
package de.caff.util.args;

import de.caff.annotation.NotNull;

import java.util.Collection;
import java.util.Collections;

/**
 * Basic implementation of a simple switch.
 * This switch just has one short and one long form.
 * @author <a href="mailto:rammi@caff.de">Rammi</a>
 * @since January 27, 2019
 */
public abstract class AbstractSwitch
        implements Switch
{
  @NotNull
  protected final Character shortForm;
  @NotNull
  protected final String longForm;
  @NotNull
  protected final String description;

  /**
   * Constructor.
   * @param shortForm short form of the switch
   * @param longForm  long form of the switch
   * @param description description or this switch
   */
  protected AbstractSwitch(@NotNull Character shortForm, @NotNull String longForm,
                           @NotNull String description)
  {
    this.shortForm = shortForm;
    this.longForm = longForm;
    this.description = description;
  }

  @NotNull
  @Override
  public Collection<Character> getShortForms()
  {
    return Collections.singleton(shortForm);
  }

  @NotNull
  @Override
  public Collection<String> getLongForms()
  {
    return Collections.singleton(longForm);
  }

  @NotNull
  @Override
  public String getDescription()
  {
    return description;
  }
}
