// ============================================================================
// File:               AbstractMultipleSwitch
//
// Project:            CAFF
//
// Purpose:            
//
// Author:             Rammi
//
// Copyright Notice:   © 2025  Rammi (rammi@caff.de)
//                     The usage of this source code in commercial or open 
//                     source projects is not allowed without explicit 
//                     permission.
//
// Created:            3/16/25 4:47 PM
//=============================================================================
package de.caff.util.args;

import de.caff.annotation.NotNull;

/**
 * A switch which may appear on the command line multiple times.
 *
 * @author <a href="mailto:rammi@caff.de">Rammi</a>
 * @since March 16, 2025
 */
public abstract class AbstractMultipleSwitch
        extends AbstractSwitch
{
  protected final int minCount;
  protected final int maxCount;

  protected AbstractMultipleSwitch(@NotNull Character shortForm, @NotNull String longForm, @NotNull String description,
                                int minCount)
  {
    this(shortForm, longForm, description, minCount, Integer.MAX_VALUE);
  }

  protected AbstractMultipleSwitch(@NotNull Character shortForm, @NotNull String longForm, @NotNull String description,
                                int minCount, int maxCount)
  {
    super(shortForm, longForm, description);
    this.minCount = minCount;
    this.maxCount = maxCount;
  }
}
