package de.caff.util.args;

public abstract class AbstractBasicMultipleArgument extends AbstractBasicArgument {
    protected final int minCount;
    protected final int maxCount;

    protected AbstractBasicMultipleArgument(String name, String description, int minCount, int maxCount) {
        super(name, description);
        this.minCount = minCount;
        this.maxCount = maxCount;
    }

    protected AbstractBasicMultipleArgument(String name, String description, int minCount) {
        this (name, description, minCount, Integer.MAX_VALUE);
    }

    @Override
    public boolean isVarLength() {
        return maxCount > 1  &&   maxCount > minCount;
    }

    @Override
    public int getMinimalCount() {
        return minCount;
    }

    @Override
    public int getMaximalCount() {
        return maxCount;
    }
}
