// ============================================================================
// COPYRIGHT NOTICE
// ----------------------------------------------------------------------------
// (This is the open source ISC license, see
// http://en.wikipedia.org/wiki/ISC_license
// for more info)
//
// Copyright © 2016-2024  Andreas M. Rammelt <rammi@caff.de>
//
// Permission to use, copy, modify, and/or distribute this software for any
// purpose with or without fee is hereby granted, provided that the above
// copyright notice and this permission notice appear in all copies.
//
// THE SOFTWARE IS PROVIDED "AS IS" AND THE AUTHOR DISCLAIMS ALL WARRANTIES
// WITH REGARD TO THIS SOFTWARE INCLUDING ALL IMPLIED WARRANTIES OF
// MERCHANTABILITY AND FITNESS. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR
// ANY SPECIAL, DIRECT, INDIRECT, OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
// WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN
// ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF
// OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
//=============================================================================
// Latest version on https://caff.de/projects/decaff-commons/
//=============================================================================
package de.caff.util;

import de.caff.generics.function.Function1;

/**
 * Primitives helper tool.
 * @author <a href="mailto:rammi@caff.de">Rammi</a>
 * @deprecated Moved to different package, use {@link de.caff.generics.Primitives} instead
 */
@Deprecated
public final class Primitives
{
  /** Don't construct. */
  private Primitives()
  {
  }

  /**
   * Function which clones byte arrays.
   * {@code null} is accepted.
   */
  public static final Function1<byte[], byte[]> BYTE_ARRAY_CLONER =
          arg -> arg != null
                  ? arg.clone()
                  : null;
  /**
   * Function which clones short arrays.
   * {@code null} is accepted.
   */
  public static final Function1<short[], short[]> SHORT_ARRAY_CLONER =
          arg -> arg != null
                  ? arg.clone()
                  : null;
  /**
   * Function which clones int arrays.
   * {@code null} is accepted.
   */
  public static final Function1<int[], int[]> INT_ARRAY_CLONER =
          arg -> arg != null
                  ? arg.clone()
                  : null;
  /**
   * Function which clones long arrays.
   * {@code null} is accepted.
   */
  public static final Function1<long[], long[]> LONG_ARRAY_CLONER =
          arg -> arg != null
                  ? arg.clone()
                  : null;
  /**
   * Function which clones char arrays.
   * {@code null} is accepted.
   */
  public static final Function1<char[], char[]> CHAR_ARRAY_CLONER =
          arg -> arg != null
                  ? arg.clone()
                  : null;
  /**
   * Function which clones float arrays.
   * {@code null} is accepted.
   */
  public static final Function1<float[], float[]> FLOAT_ARRAY_CLONER =
          arg -> arg != null
                  ? arg.clone()
                  : null;
  /**
   * Function which clones double arrays.
   * {@code null} is accepted.
   */
  public static final Function1<double[], double[]> DOUBLE_ARRAY_CLONER =
          arg -> arg != null
                  ? arg.clone()
                  : null;

  /**
   * Get the unsigned value of a byte.
   * @param b byte value
   * @return unsigned value between {@code 0x00} and {@code 0xFF}
   */
  public static int unsigned(byte b)
  {
    return b & 0xff;
  }

  /**
   * Get the unsigned value of a short int.
   * @param s short value
   * @return unsigned value between {@code 0x0000} and {@code 0xFFFF}
   */
  public static int unsigned(short s)
  {
    return s & 0xffff;
  }

  /**
   * Get the unsigned value of an integer.
   * @param i int value
   * @return unsigned value between {@code 0x00000000} and {@code 0xFFFFFFFF}
   */
  public static long unsigned(int i)
  {
    return i & 0xffffffffL;
  }
}
