// ============================================================================
// COPYRIGHT NOTICE
// ----------------------------------------------------------------------------
// (This is the open source ISC license, see
// http://en.wikipedia.org/wiki/ISC_license
// for more info)
//
// Copyright © 2005-2024  Andreas M. Rammelt <rammi@caff.de>
//
// Permission to use, copy, modify, and/or distribute this software for any
// purpose with or without fee is hereby granted, provided that the above
// copyright notice and this permission notice appear in all copies.
//
// THE SOFTWARE IS PROVIDED "AS IS" AND THE AUTHOR DISCLAIMS ALL WARRANTIES
// WITH REGARD TO THIS SOFTWARE INCLUDING ALL IMPLIED WARRANTIES OF
// MERCHANTABILITY AND FITNESS. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR
// ANY SPECIAL, DIRECT, INDIRECT, OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
// WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN
// ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF
// OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
//=============================================================================
// Latest version on https://caff.de/projects/decaff-commons/
//=============================================================================
package de.caff.util;

import de.caff.annotation.NotNull;

import java.awt.*;

/**
 *  A listener which is used in {@link Utility} as a callback
 *  for exceptions which occur in the event queue.
 *  @author <a href="mailto:rammi@caff.de">Rammi</a>
 */
public interface EventQueueExceptionListener
{
  /**
   *  Called when an uncaught exception occurs in the AWT event thread.
   *  It may pop up a dialog, print something to the console, end the program
   *  or raise an exception of its own which then is handled the standard way.
   *  The listeners are called in the AWT thread.
   * 
   *  @param event      the event which raised the exception
   *  @param exception  the uncaught exception
   */
  public void exceptionOccured(@NotNull AWTEvent event,
                               @NotNull Throwable exception);
}
