// ============================================================================
// COPYRIGHT NOTICE
// ----------------------------------------------------------------------------
// (This is the open source ISC license, see
// http://en.wikipedia.org/wiki/ISC_license
// for more info)
//
// Copyright © 2015-2024  Andreas M. Rammelt <rammi@caff.de>
//
// Permission to use, copy, modify, and/or distribute this software for any
// purpose with or without fee is hereby granted, provided that the above
// copyright notice and this permission notice appear in all copies.
//
// THE SOFTWARE IS PROVIDED "AS IS" AND THE AUTHOR DISCLAIMS ALL WARRANTIES
// WITH REGARD TO THIS SOFTWARE INCLUDING ALL IMPLIED WARRANTIES OF
// MERCHANTABILITY AND FITNESS. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR
// ANY SPECIAL, DIRECT, INDIRECT, OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
// WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN
// ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF
// OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
//=============================================================================
// Latest version on https://caff.de/projects/decaff-commons/
//=============================================================================
package de.caff.util;

import de.caff.annotation.NotNull;
import de.caff.annotation.Nullable;
import de.caff.generics.Indexable;
import de.caff.util.debug.Debug;

/**
 * Toolbox for enums.
 *
 * @author <a href="mailto:rammi@caff.de">Rammi</a>
 * @deprecated move to {@link de.caff.generics.Enums} in module generics
 */
@Deprecated
public class Enums
{
  /** Don't create. */
  private Enums() {}

  /**
   * Get an enum value from its ordinal.
   * @param values  enum values with ordinal indices
   * @param ordinal enum ordinal
   * @param <E> type of returned value, usually an enum but this is not enforced
   * @return associated value or {@code null} if there is no matching value
   */
  @Nullable
  public static <E> E getEnumFromOrdinal(@NotNull E[] values,
                                         int ordinal)
  {
    return ordinal >= 0 && ordinal < values.length
            ? values[ordinal]
            : null;
  }

  /**
   * Get an enum value from its ordinal.
   * @param values  enum values with ordinal indices
   * @param ordinal enum ordinal
   * @param <E> type of returned value, usually an enum but this is not enforced
   * @return associated value or {@code null} if there is no matching value
   */
  @Nullable
  public static <E> E getEnumFromOrdinal(@NotNull Indexable<E> values,
                                         int ordinal)
  {
    return ordinal >= 0 && ordinal < values.size()
            ? values.get(ordinal)
            : null;
  }

  /**
   * Get an enum value from its ordinal.
   * @param values  enum values with ordinal indices
   * @param ordinal enum ordinal
   * @param defaultValue default value returned if ordinal is out of range
   * @param <E> type of returned value, usually an enum but this is not enforced
   * @return associated value or {@code defaultValue} if there is no matching value
   */
  @NotNull
  public static <E> E getEnumFromOrdinal(@NotNull E[] values,
                                         int ordinal,
                                         @NotNull E defaultValue)
  {
    final E result = getEnumFromOrdinal(values, ordinal);
    if (result == null) {
      Debug.warn("Fixing non-matched enum ordinal %0 to %1", ordinal, defaultValue);
      return defaultValue;
    }
    return result;
  }

  /**
   * Get an enum value from its ordinal.
   * @param values  enum values with ordinal indices
   * @param ordinal enum ordinal
   * @param defaultValue default value returned if ordinal is out of range
   * @param <E> type of returned value, usually an enum but this is not enforced
   * @return associated value or {@code defaultValue} if there is no matching value
   */
  @NotNull
  public static <E> E getEnumFromOrdinal(@NotNull Indexable<E> values,
                                         int ordinal,
                                         @NotNull E defaultValue)
  {
    final E result = getEnumFromOrdinal(values, ordinal);
    if (result == null) {
      Debug.warn("Fixing non-matched enum ordinal %0 to %1", ordinal, defaultValue);
      return defaultValue;
    }
    return result;
  }
}
