// ============================================================================
// COPYRIGHT NOTICE
// ----------------------------------------------------------------------------
// (This is the open source ISC license, see
// http://en.wikipedia.org/wiki/ISC_license
// for more info)
//
// Copyright © 2015-2024  Andreas M. Rammelt <rammi@caff.de>
//
// Permission to use, copy, modify, and/or distribute this software for any
// purpose with or without fee is hereby granted, provided that the above
// copyright notice and this permission notice appear in all copies.
//
// THE SOFTWARE IS PROVIDED "AS IS" AND THE AUTHOR DISCLAIMS ALL WARRANTIES
// WITH REGARD TO THIS SOFTWARE INCLUDING ALL IMPLIED WARRANTIES OF
// MERCHANTABILITY AND FITNESS. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR
// ANY SPECIAL, DIRECT, INDIRECT, OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
// WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN
// ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF
// OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
//=============================================================================
// Latest version on https://caff.de/projects/decaff-commons/
//=============================================================================
package de.caff.util;

import de.caff.annotation.NotNull;

/**
 * A single bit flag.
 *
 * @author <a href="mailto:rammi@caff.de">Rammi</a>
 */
public interface BitFlag
{
  /**
   * Is this flag set in the given mask?
   * @param mask bit mask
   * @return {@code true}: if the flag is set<br>
   *         {@code false}: if the flag is not set
   */
  boolean isSetIn(@NotNull BitMask mask);

  /**
   * Set this flag in the given bit mask.
   * @param mask bit mask
   * @return new bit mask where this flag is set
   */
  @NotNull
  BitMask setIn(@NotNull BitMask mask);

  /**
   * Clear this flag in the given bit mask.
   * @param mask bit mask
   * @return new bit mask where this flag is cleared
   */
  @NotNull
  BitMask clearIn(@NotNull BitMask mask);
}
