// ============================================================================
// File:               XmlStorable
//
// Project:            CAFF
//
// Purpose:            
//
// Author:             Rammi
//
// Copyright Notice:   © 2022-2024  Rammi (rammi@caff.de)
//                     The usage of this source code in commercial or open 
//                     source projects is not allowed without explicit 
//                     permission.
//
// Created:            12/9/22 3:52 PM
//=============================================================================
package de.caff.io.xml;

import de.caff.annotation.NotNull;
import de.caff.io.TextStringCollector;

/**
 * Interface for items which can be stored as XML.
 * @author <a href="mailto:rammi@caff.de">Rammi</a>
 * @since December 09, 2022
 */
@FunctionalInterface
public interface XmlStorable
{
  /**
   * Store this as XML.
   * @param xml simple XML writer
   */
  void storeXml(@NotNull SimpleXmlWriter xml);

  /**
   * Convert this item into partial XML text.
   * @return XML-formatted text representing this item
   */
  @NotNull
  default String toXmlText()
  {
    final TextStringCollector text = new TextStringCollector();
    try (SimpleXmlWriter xml = new SimpleXmlWriter(text, 2)) {
      storeXml(xml);
    }
    return text.getText();
  }
}
