// ============================================================================
// COPYRIGHT NOTICE
// ----------------------------------------------------------------------------
// (This is the open source ISC license, see
// http://en.wikipedia.org/wiki/ISC_license
// for more info)
//
// Copyright © 2013-2024  Andreas M. Rammelt <rammi@caff.de>
//
// Permission to use, copy, modify, and/or distribute this software for any
// purpose with or without fee is hereby granted, provided that the above
// copyright notice and this permission notice appear in all copies.
//
// THE SOFTWARE IS PROVIDED "AS IS" AND THE AUTHOR DISCLAIMS ALL WARRANTIES
// WITH REGARD TO THIS SOFTWARE INCLUDING ALL IMPLIED WARRANTIES OF
// MERCHANTABILITY AND FITNESS. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR
// ANY SPECIAL, DIRECT, INDIRECT, OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
// WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN
// ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF
// OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
//=============================================================================
// Latest version on https://caff.de/projects/decaff-commons/
//=============================================================================
package de.caff.i18n;

import java.util.Locale;

/**
 * @author <a href="mailto:rammi@caff.de">Rammi</a>
 */
public interface ResourcedThrowable
{
  /**
   *  Get the message with default locale.
   *  @return  message
   */
  String getMessage();

  /**
   *  Get the message for a locale.
   *  @param l requested locale
   *  @return message for the given locale
   */
  String getMessage(Locale l);

  /**
   *  Get the exception from where this resourced exception originated.
   *  @return original exception or {@code null} if there is no original
   *          exception
   */
  Throwable getOriginalException();

  /**
   *  Set the exception from where this resourced exception originated.
   *  @param originalException original exception
   */
  void setOriginalException(Throwable originalException);
}
