// ============================================================================
// COPYRIGHT NOTICE
// ----------------------------------------------------------------------------
// (This is the open source ISC license, see
// http://en.wikipedia.org/wiki/ISC_license
// for more info)
//
// Copyright © 2005-2024  Andreas M. Rammelt <rammi@caff.de>
//
// Permission to use, copy, modify, and/or distribute this software for any
// purpose with or without fee is hereby granted, provided that the above
// copyright notice and this permission notice appear in all copies.
//
// THE SOFTWARE IS PROVIDED "AS IS" AND THE AUTHOR DISCLAIMS ALL WARRANTIES
// WITH REGARD TO THIS SOFTWARE INCLUDING ALL IMPLIED WARRANTIES OF
// MERCHANTABILITY AND FITNESS. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR
// ANY SPECIAL, DIRECT, INDIRECT, OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
// WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN
// ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF
// OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
//=============================================================================
// Latest version on https://caff.de/projects/decaff-commons/
//=============================================================================
package de.caff.util.settings.swing;

import de.caff.i18n.I18n;

import java.util.ListResourceBundle;

/**
 *  Default i18n resources for the swing package.
 *
 *  @author <a href="mailto:rammi@caff.de">Rammi</a>
 */
public class SettingsResourceBundle_pt_BR
        extends ListResourceBundle
{
  /**
   *  Get the contents of this bundle.
   *  @return  the contents
   */
   @Override
   public Object[][] getContents() {
    return contents;
  }

  private static final Object[][] contents = {
    // LOCALIZE THIS
    // General
    { "Ok"+I18n.SUFFIX_TEXT,            "Ok" },
    { "Cancel"+I18n.SUFFIX_TEXT,        "Cancelar" },

    { "Add"+I18n.SUFFIX_TEXT,           "Adicionar" },
    { "Delete"+I18n.SUFFIX_TEXT,        "Excluir" },
    { "Change"+I18n.SUFFIX_TEXT,        "Mudar" },
    { "Up"+I18n.SUFFIX_TEXT,            "Mover para cima" },
    { "Down"+I18n.SUFFIX_TEXT,          "Mover para baixo" },

    // Toolbars
    { "tbAdd"+I18n.SUFFIX_TEXT,           "Adicionar" },
    { "tbAdd"+I18n.SUFFIX_TOOLTIP,        "Adicionar URL" },

    { "tbDelete"+I18n.SUFFIX_TEXT,        "Excluir" },
    { "tbDelete"+I18n.SUFFIX_TOOLTIP,     "Excluir URL selecionada da lista" },

    { "tbChange"+I18n.SUFFIX_TEXT,        "Editar" },
    { "tbChange"+I18n.SUFFIX_TOOLTIP,     "Editar URL selecionada" },

    { "tbUp"+I18n.SUFFIX_TEXT,            "Mover para cima" },
    { "ttUp"+I18n.SUFFIX_TOOLTIP,         "Mover URL selecionada um passo a cima" },

    { "tbDown"+I18n.SUFFIX_TEXT,          "Move para baixo" },
    { "tbDown"+I18n.SUFFIX_TOOLTIP,       "Mover URL selecionada um passo a baixo" },

    // title
    { "tiFontUrl",                        "Escolha URL fonte" },   

    // labels
    { "lbFontUrl"+I18n.SUFFIX_TEXT,       "URL Fonte:" },

    // buttons
    { "btChangeColor"+I18n.SUFFIX_TEXT,   "Mudar a cor..." },

    { "btFontUrl"+I18n.SUFFIX_TEXT,       "..." },
    { "btFontUrl"+I18n.SUFFIX_TOOLTIP,    "Selecionar diretório local" },

    // The standard format used if a text does not end in a punctuation. %0 contains the text.
    { "valueNameFormat", "%0:" },
    // The format used if a text does end in a punctuation. %0 contains the text, %1 contains the text w/o the punctuation.
    { "valueNameFormatPunctuation", "%0" },
    // What is considered a punctuation.
    { "valueNamePunctuation", ":?." },
  };
}
