// ============================================================================
// COPYRIGHT NOTICE
// ----------------------------------------------------------------------------
// (This is the open source ISC license, see
// http://en.wikipedia.org/wiki/ISC_license
// for more info)
//
// Copyright © 2005-2024  Andreas M. Rammelt <rammi@caff.de>
//
// Permission to use, copy, modify, and/or distribute this software for any
// purpose with or without fee is hereby granted, provided that the above
// copyright notice and this permission notice appear in all copies.
//
// THE SOFTWARE IS PROVIDED "AS IS" AND THE AUTHOR DISCLAIMS ALL WARRANTIES
// WITH REGARD TO THIS SOFTWARE INCLUDING ALL IMPLIED WARRANTIES OF
// MERCHANTABILITY AND FITNESS. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR
// ANY SPECIAL, DIRECT, INDIRECT, OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
// WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN
// ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF
// OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
//=============================================================================
// Latest version on https://caff.de/projects/decaff-commons/
//=============================================================================
package de.caff.util.settings.swing;

import de.caff.i18n.I18n;

import java.util.ListResourceBundle;

/**
 *  Default i18n resources for the swing package.
 *
 *  @author <a href="mailto:rammi@caff.de">Rammi</a>
 */
public class SettingsResourceBundle_de
        extends ListResourceBundle
{
  /**
   *  Get the contents of this bundle.
   *  @return  the contents
   */
   @Override
   public Object[][] getContents() {
    return contents;
  }

  private static final Object[][] contents = {
    // LOCALIZE THIS
    // General
    { "Ok"+I18n.SUFFIX_TEXT,            "Ok" },
    { "Cancel"+I18n.SUFFIX_TEXT,        "Abbruch" },

    { "Add"+I18n.SUFFIX_TEXT,           "Hinzufügen" },
    { "Delete"+I18n.SUFFIX_TEXT,        "Löschen" },
    { "Change"+I18n.SUFFIX_TEXT,        "Ändern" },
    { "Up"+I18n.SUFFIX_TEXT,            "Nach oben" },
    { "Down"+I18n.SUFFIX_TEXT,          "Nach unten" },

    // Toolbars
    { "tbAdd"+I18n.SUFFIX_TEXT,           "Hinzufügen" },
    { "tbAdd"+I18n.SUFFIX_TOOLTIP,        "URL hinzufügen" },

    { "tbDelete"+I18n.SUFFIX_TEXT,        "Löschen" },
    { "tbDelete"+I18n.SUFFIX_TOOLTIP,     "Selektierte URL löschen" },

    { "tbChange"+I18n.SUFFIX_TEXT,        "Ändern" },
    { "tbChange"+I18n.SUFFIX_TOOLTIP,     "Selektierte URL editieren" },

    { "tbUp"+I18n.SUFFIX_TEXT,            "Hoch" },
    { "tbUp"+I18n.SUFFIX_TOOLTIP,         "Selektierte URL einen Schritt höher schieben" },

    { "tbDown"+I18n.SUFFIX_TEXT,          "Runter" },
    { "tbDown"+I18n.SUFFIX_TOOLTIP,       "Selektierte URL einen Schritt tiefer schieben" },

    { "tbResetToDefaults"+I18n.SUFFIX_TEXT, "Standardwerte" },
    { "tbResetToDefaults"+I18n.SUFFIX_TOOLTIP, "Setzt die Standartwerte wieder ein" },

    // title
    { "tiFontUrl",                        "Font-URL auswählen" },   

    // labels
    { "lbFontUrl"+I18n.SUFFIX_TEXT,       "Font-URL:" },

    // buttons
    { "btChangeColor"+I18n.SUFFIX_TEXT,   "Farbe ändern..." },

    { "btFontUrl"+I18n.SUFFIX_TEXT,       "..." },
    { "btFontUrl"+I18n.SUFFIX_TOOLTIP,    "Lokales Verzeichnis auswählen" },

    { "ppLookAndFeel" + I18n.SUFFIX_TEXT,     "Look and Feel" },
    { "ppLookAndFeel" + I18n.SUFFIX_MNEMONIC, "L" },
    { "ppLookAndFeel" + I18n.SUFFIX_TOOLTIP,  "Erlaubt es, das generelle Aussehen des Programms auszutauschen" },

    // The standard format used if a text does not end in a punctuation. %0 contains the text.
    { "valueNameFormat", "%0:" },
    // The format used if a text does end in a punctuation. %0 contains the text, %1 contains the text w/o the punctuation.
    { "valueNameFormatPunctuation", "%0" },
    // What is considered a punctuation.
    { "valueNamePunctuation", ":?." },
  };
}
