// ============================================================================
// COPYRIGHT NOTICE
// ----------------------------------------------------------------------------
// (This is the open source ISC license, see
// http://en.wikipedia.org/wiki/ISC_license
// for more info)
//
// Copyright © 2005-2024  Andreas M. Rammelt <rammi@caff.de>
//
// Permission to use, copy, modify, and/or distribute this software for any
// purpose with or without fee is hereby granted, provided that the above
// copyright notice and this permission notice appear in all copies.
//
// THE SOFTWARE IS PROVIDED "AS IS" AND THE AUTHOR DISCLAIMS ALL WARRANTIES
// WITH REGARD TO THIS SOFTWARE INCLUDING ALL IMPLIED WARRANTIES OF
// MERCHANTABILITY AND FITNESS. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR
// ANY SPECIAL, DIRECT, INDIRECT, OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
// WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN
// ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF
// OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
//=============================================================================
// Latest version on https://caff.de/projects/decaff-commons/
//=============================================================================
package de.caff.util.settings.swing;

import de.caff.i18n.I18n;

import java.util.ListResourceBundle;

/**
 *  Default i18n resources for the swing package.
 *
 *  @author <a href="mailto:rammi@caff.de">Rammi</a>
 */
public class SettingsResourceBundle
        extends ListResourceBundle
{
  /**
   *  Get the contents of this bundle.
   *  @return  the contents
   */
   @Override
   public Object[][] getContents() {
    return contents;
  }

  private static final Object[][] contents = {
    // LOCALIZE THIS
    // General
    { "Ok"+I18n.SUFFIX_TEXT,            "Ok" },
    { "Cancel"+I18n.SUFFIX_TEXT,        "Cancel" },

    { "Add"+I18n.SUFFIX_TEXT,           "Add" },
    { "Delete"+I18n.SUFFIX_TEXT,        "Delete" },
    { "Change"+I18n.SUFFIX_TEXT,        "Change" },
    { "Up"+I18n.SUFFIX_TEXT,            "Move Up" },
    { "Down"+I18n.SUFFIX_TEXT,          "Move Down" },

    // Toolbars
    { "tbAdd"+I18n.SUFFIX_TEXT,           "Add" },
    { "tbAdd"+I18n.SUFFIX_TOOLTIP,        "Add URL" },

    { "tbDelete"+I18n.SUFFIX_TEXT,        "Delete" },
    { "tbDelete"+I18n.SUFFIX_TOOLTIP,     "Delete selected URL from list" },

    { "tbChange"+I18n.SUFFIX_TEXT,        "Edit" },
    { "tbChange"+I18n.SUFFIX_TOOLTIP,     "Edit selected URL" },

    { "tbUp"+I18n.SUFFIX_TEXT,            "Move Up" },
    { "tbUp"+I18n.SUFFIX_TOOLTIP,         "Move selected URL one step up" },

    { "tbDown"+I18n.SUFFIX_TEXT,          "Move Down" },
    { "tbDown"+I18n.SUFFIX_TOOLTIP,       "Move selected URL one step down" },

    { "tbResetToDefaults"+I18n.SUFFIX_TEXT, "Defaults" },
    { "tbResetToDefaults"+I18n.SUFFIX_TOOLTIP, "Restores the initial default values" },

    // title
    { "tiFontUrl",                        "Choose Font URL" },   

    // labels
    { "lbFontUrl"+I18n.SUFFIX_TEXT,       "Font URL:" },

    // buttons
    { "btChangeColor"+I18n.SUFFIX_TEXT,   "Change Color..." },

    { "btFontUrl"+I18n.SUFFIX_TEXT,       "..." },
    { "btFontUrl"+I18n.SUFFIX_TOOLTIP,    "Select local directory" },

    { "ppLookAndFeel" + I18n.SUFFIX_TEXT,     "Look and Feel" },
    { "ppLookAndFeel" + I18n.SUFFIX_MNEMONIC, "L" },
    { "ppLookAndFeel" + I18n.SUFFIX_TOOLTIP,  "Allows to select the look and feel of the complete application" },

    // The standard format used if a text does not end in a punctuation. %0 contains the text.
    { "valueNameFormat", "%0:" },
    // The format used if a text does end in a punctuation. %0 contains the text, %1 contains the text w/o the punctuation.
    { "valueNameFormatPunctuation", "%0" },
    // What is considered a punctuation.
    { "valueNamePunctuation", ":?." },
  };
}
