// ============================================================================
// COPYRIGHT NOTICE
// ----------------------------------------------------------------------------
// (This is the open source ISC license, see
// http://en.wikipedia.org/wiki/ISC_license
// for more info)
//
// Copyright © 2014-2024  Andreas M. Rammelt <rammi@caff.de>
//
// Permission to use, copy, modify, and/or distribute this software for any
// purpose with or without fee is hereby granted, provided that the above
// copyright notice and this permission notice appear in all copies.
//
// THE SOFTWARE IS PROVIDED "AS IS" AND THE AUTHOR DISCLAIMS ALL WARRANTIES
// WITH REGARD TO THIS SOFTWARE INCLUDING ALL IMPLIED WARRANTIES OF
// MERCHANTABILITY AND FITNESS. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR
// ANY SPECIAL, DIRECT, INDIRECT, OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
// WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN
// ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF
// OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
//=============================================================================
// Latest version on https://caff.de/projects/decaff-commons/
//=============================================================================
package de.caff.util.settings.swing;

import de.caff.annotation.NotNull;
import de.caff.annotation.Nullable;

import javax.swing.*;
import java.util.Locale;

/**
 * Editor provider which just provides a fix text.
 * @author <a href="mailto:rammi@caff.de">Rammi</a>
 */
public class FixEditorProvider
        extends AbstractBasicEditorProvider
{
  private final JLabel editor;

  /**
   * Constructor.
   *
   * @param baseTag base tag (will be expanded by various suffixes)
   * @param l       locale
   * @param fixText fix text displayed in editor component
   */
  public FixEditorProvider(@NotNull String baseTag, @Nullable Locale l, @Nullable String fixText)
  {
    super(baseTag, l);
    this.editor = new JLabel(fixText);
  }

  /**
   * Get an component for editing .
   *
   * @return editor component, use non-editing components like labels for fix properties
   */
  @NotNull
  @Override
  public JComponent getEditor()
  {
    return editor;
  }

  /**
   * Reset the value in the editor to the basic value.
   */
  @Override
  public void reset()
  {
    // nothing to do.
  }

  /**
   * Set the basic value from the editor.
   */
  @Override
  public void save()
  {
    // nothing to do
  }

  /**
   * Called when the editor provider is no longer used.
   */
  @Override
  public void goodBye()
  {
    // nothing to do
  }
}
