// ============================================================================
// COPYRIGHT NOTICE
// ----------------------------------------------------------------------------
// (This is the open source ISC license, see
// http://en.wikipedia.org/wiki/ISC_license
// for more info)
//
// Copyright © 2005-2024  Andreas M. Rammelt <rammi@caff.de>
//
// Permission to use, copy, modify, and/or distribute this software for any
// purpose with or without fee is hereby granted, provided that the above
// copyright notice and this permission notice appear in all copies.
//
// THE SOFTWARE IS PROVIDED "AS IS" AND THE AUTHOR DISCLAIMS ALL WARRANTIES
// WITH REGARD TO THIS SOFTWARE INCLUDING ALL IMPLIED WARRANTIES OF
// MERCHANTABILITY AND FITNESS. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR
// ANY SPECIAL, DIRECT, INDIRECT, OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
// WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN
// ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF
// OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
//=============================================================================
// Latest version on https://caff.de/projects/decaff-commons/
//=============================================================================
package de.caff.util.settings.swing;

import de.caff.annotation.NotNull;
import de.caff.annotation.Nullable;

import javax.swing.*;

/**
 *  A name and a component.
 *  @author <a href="mailto:rammi@caff.de">Rammi</a>
 */
public interface EditorProvider
{
  /**
   * Get the label text.
   * @return label text
   */
  @Nullable
  String getLabelText();

  /**
   *  Get a label component for this editor.
   *  If the returned component is null the {@link #getEditor() editor component}
   *  is inserted without a label.
   *  @return something used as a label component, or {@code null}
   */
  @Nullable
  JComponent getLabel();

  /**
   *  Get a title text for this editor component.
   *  @return a title text or {@code null} if a title makes no sense
   */
  @Nullable
  String getTitleText();

  /**
   *  Get a tool tip string for this editor component.
   *  @return tooltip text or {@code null} if no tooltip is used
   */
  @Nullable
  String getToolTipText();

  /**
   *  Get a description for the property used.
   *  @return description, possibly multi-line
   */
  @Nullable
  String getDescription();

  /**
   *  Get a component for editing.
   *  @return editor component, use non-editing components like labels for fix properties
   */
  @NotNull
  JComponent getEditor();

  /**
   *  Is the value in the editor component valid?
   *  @return {@code true} if the value is valid<br>
   *          {@code false} otherwise
   */
  boolean isValidValue();

  /**
   *  Reset the value in the editor to the basic value.
   */
  void reset();

  /**
   *  Set the basic value from the editor.
   */
  void save();

  /**
   *  Called when the editor provider is no longer used.
   */
  void goodBye();
}
