// ============================================================================
// COPYRIGHT NOTICE
// ----------------------------------------------------------------------------
// (This is the open source ISC license, see
// http://en.wikipedia.org/wiki/ISC_license
// for more info)
//
// Copyright © 2005-2024  Andreas M. Rammelt <rammi@caff.de>
//
// Permission to use, copy, modify, and/or distribute this software for any
// purpose with or without fee is hereby granted, provided that the above
// copyright notice and this permission notice appear in all copies.
//
// THE SOFTWARE IS PROVIDED "AS IS" AND THE AUTHOR DISCLAIMS ALL WARRANTIES
// WITH REGARD TO THIS SOFTWARE INCLUDING ALL IMPLIED WARRANTIES OF
// MERCHANTABILITY AND FITNESS. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR
// ANY SPECIAL, DIRECT, INDIRECT, OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
// WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN
// ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF
// OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
//=============================================================================
// Latest version on https://caff.de/projects/decaff-commons/
//=============================================================================
package de.caff.util.settings.swing;

import de.caff.annotation.NotNull;
import de.caff.i18n.I18n;
import de.caff.util.settings.AbstractBasicLocalizableChangeableItem;

/**
 *  Basic implementation for simple editable preference properties.
 *  This takes care of i18n by trying to get the localized label,
 *  tooltip etc by adding the i18n suffix constants in 
 *  {@link I18n} to the basic tag.
 *
 *  @author <a href="mailto:rammi@caff.de">Rammi</a>
 */
abstract class AbstractBasicSimpleEditableChangeableItem
        extends AbstractBasicLocalizableChangeableItem
        implements EditableProperty
{
  private static final long serialVersionUID = -8474884962560341752L;

  /**
   *
   *  @param basicName  basic name (prefix)
   *  @param baseTag    basic i18n tag
   */
  protected AbstractBasicSimpleEditableChangeableItem(@NotNull String basicName,
                                                      @NotNull String baseTag)
  {
    super(basicName, baseTag);
  }

}
