// ============================================================================
// COPYRIGHT NOTICE
// ----------------------------------------------------------------------------
// (This is the open source ISC license, see
// http://en.wikipedia.org/wiki/ISC_license
// for more info)
//
// Copyright © 2008-2024  Andreas M. Rammelt <rammi@caff.de>
//
// Permission to use, copy, modify, and/or distribute this software for any
// purpose with or without fee is hereby granted, provided that the above
// copyright notice and this permission notice appear in all copies.
//
// THE SOFTWARE IS PROVIDED "AS IS" AND THE AUTHOR DISCLAIMS ALL WARRANTIES
// WITH REGARD TO THIS SOFTWARE INCLUDING ALL IMPLIED WARRANTIES OF
// MERCHANTABILITY AND FITNESS. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR
// ANY SPECIAL, DIRECT, INDIRECT, OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
// WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN
// ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF
// OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
//=============================================================================
// Latest version on https://caff.de/projects/decaff-commons/
//=============================================================================
package de.caff.gimmicks.swing;

import de.caff.i18n.I18n;

import java.util.ListResourceBundle;

/**
 *  German resource bundle.
 *  @author <a href="mailto:rammi@caff.de">Rammi</a>
 */
public class GimmicksSwingResourceBundle_de
  extends ListResourceBundle
{
  /**
   * See class description.
   */
  @Override
  protected Object[][] getContents()
  {
    return contents;
  }

  private static final Object[][] contents = {
          { "nmFileFilter", "%0-Dateien" },

          // closeable tab tooltip for close button
          { "btCloseTab"+ I18n.SUFFIX_TOOLTIP, "Close this tab" },

          // === extended error dialog ===
          { ExtendedErrorDialog.I18N_TAG_EXCEPTION_TITLE, "Ausnahme" },

          { ExtendedErrorDialog.I18N_TAG_BTN_COPY + I18n.SUFFIX_TEXT,    "Inhalt kopieren" },
          { ExtendedErrorDialog.I18N_TAG_BTN_COPY + I18n.SUFFIX_TOOLTIP, "Kopiert den Inhalt in die Zwischenablage" },
          { ExtendedErrorDialog.I18N_TAG_BTN_COPY + I18n.SUFFIX_MNEMONIC, "k" },

          { ExtendedErrorDialog.I18N_TAG_BTN_CLOSE + I18n.SUFFIX_TEXT,    "Schließen" },
          { ExtendedErrorDialog.I18N_TAG_BTN_CLOSE + I18n.SUFFIX_TOOLTIP, "Schließt diesen Dialog" },
          { ExtendedErrorDialog.I18N_TAG_BTN_CLOSE + I18n.SUFFIX_MNEMONIC, "S" },

          { ExtendedErrorDialog.I18N_TAG_ERROR_COPY, "Kopieren in die Zwischenablage ist fehlgeschlagen!\nGrund:\n%0" },
          { ExtendedErrorDialog.I18N_TAG_TITLE_ERROR_COPY, "Kopierfehler" },

          { CollapsiblePane.I18N_TAG_ACTION_HIDE_NORTH + I18n.SUFFIX_TEXT, "▲" },
          { CollapsiblePane.I18N_TAG_ACTION_HIDE_NORTH + I18n.SUFFIX_TOOLTIP, "Seitenpaneel verstecken" },
          { CollapsiblePane.I18N_TAG_ACTION_HIDE_EAST + I18n.SUFFIX_TEXT, "▶" },
          { CollapsiblePane.I18N_TAG_ACTION_HIDE_EAST + I18n.SUFFIX_TOOLTIP, "Seitenpaneel verstecken" },
          { CollapsiblePane.I18N_TAG_ACTION_HIDE_SOUTH + I18n.SUFFIX_TEXT, "▼" },
          { CollapsiblePane.I18N_TAG_ACTION_HIDE_SOUTH + I18n.SUFFIX_TOOLTIP, "Seitenpaneel verstecken" },
          { CollapsiblePane.I18N_TAG_ACTION_HIDE_WEST + I18n.SUFFIX_TEXT, "◀" },
          { CollapsiblePane.I18N_TAG_ACTION_HIDE_WEST + I18n.SUFFIX_TOOLTIP, "Seitenpaneel verstecken" },

  };
}
