/*
 * Decompiled with CFR 0.152.
 */
package de.caff.version;

import de.caff.annotation.NotNull;
import de.caff.annotation.Nullable;
import de.caff.generics.Indexable;
import de.caff.generics.Types;
import java.util.Comparator;
import java.util.Objects;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class SemVer
implements Comparable<SemVer> {
    private static final String RE_GRP_MAJOR = "major";
    private static final String RE_GRP_MINOR = "minor";
    private static final String RE_GRP_PATCH = "patch";
    private static final String RE_GRP_PRERELEASE = "prerelease";
    private static final String RE_GRP_BUILD = "build";
    private static final String RE_VERSION = "0|[1-9][0-9]*";
    private static final String RE_BUILD_ITEM = "[0-9a-zA-Z-]";
    private static final String RE_BUILD = "[0-9a-zA-Z-]+(?:\\.[0-9a-zA-Z-]+)*";
    private static final String RE_PRERELEASE = "(?:0|[1-9][0-9]*|[0-9]*[a-zA-Z-][0-9a-zA-Z-]*)(?:\\.(?:0|[1-9][0-9]*|[0-9]*[a-zA-Z-][0-9a-zA-Z-]*))*";
    private static final String REGEXP = "^(?<major>0|[1-9][0-9]*)\\.(?<minor>0|[1-9][0-9]*)\\.(?<patch>0|[1-9][0-9]*)(?:-(?<prerelease>(?:0|[1-9][0-9]*|[0-9]*[a-zA-Z-][0-9a-zA-Z-]*)(?:\\.(?:0|[1-9][0-9]*|[0-9]*[a-zA-Z-][0-9a-zA-Z-]*))*))?(?:\\+(?<build>[0-9a-zA-Z-]+(?:\\.[0-9a-zA-Z-]+)*))?$";
    private static final Pattern PATTERN = Pattern.compile("^(?<major>0|[1-9][0-9]*)\\.(?<minor>0|[1-9][0-9]*)\\.(?<patch>0|[1-9][0-9]*)(?:-(?<prerelease>(?:0|[1-9][0-9]*|[0-9]*[a-zA-Z-][0-9a-zA-Z-]*)(?:\\.(?:0|[1-9][0-9]*|[0-9]*[a-zA-Z-][0-9a-zA-Z-]*))*))?(?:\\+(?<build>[0-9a-zA-Z-]+(?:\\.[0-9a-zA-Z-]+)*))?$");
    private static final Pattern PATTERN_VERSION = Pattern.compile("^0|[1-9][0-9]*$");
    private static final Pattern PATTERN_PRERELEASE = Pattern.compile("^(?:0|[1-9][0-9]*|[0-9]*[a-zA-Z-][0-9a-zA-Z-]*)(?:\\.(?:0|[1-9][0-9]*|[0-9]*[a-zA-Z-][0-9a-zA-Z-]*))*$");
    private static final Pattern PATTERN_BUILD_ITEM = Pattern.compile("^[0-9a-zA-Z-]$");
    private static final Pattern PATTERN_BUILD = Pattern.compile("^[0-9a-zA-Z-]+(?:\\.[0-9a-zA-Z-]+)*$");
    private static final String DOT = ".";
    static final Pattern SEP_DOT = Pattern.compile(Pattern.quote("."));
    public static final SemVer VERSION_0_0_1 = new SemVer(0, 0, 1);
    private final int major;
    private final int minor;
    private final int patch;
    @Nullable
    private final Prerelease prerelease;
    @NotNull
    private final Indexable<String> buildMetaData;

    public SemVer(int n, int n2, int n3) {
        this(n, n2, n3, null, Indexable.emptyIndexable());
    }

    public SemVer(int n, int n2, int n3, @Nullable Prerelease prerelease) {
        this(n, n2, n3, prerelease, Indexable.emptyIndexable());
    }

    public SemVer(int n, int n2, int n3, @Nullable String string) {
        this(n, n2, n3, null, string);
    }

    public SemVer(int n, int n2, int n3, @Nullable Prerelease prerelease, @Nullable String string) {
        this(n, n2, n3, prerelease, SemVer.parseBuild(string), false);
    }

    private SemVer(int n, int n2, int n3, @Nullable Prerelease prerelease, @NotNull Indexable<String> indexable) {
        this(n, n2, n3, prerelease, indexable, true);
    }

    private SemVer(int n, int n2, int n3, @Nullable Prerelease prerelease, @NotNull Indexable<String> indexable, boolean bl) {
        if (n < 0) {
            throw new IllegalArgumentException("major has to be 0 or positive, but is " + n);
        }
        if (n2 < 0) {
            throw new IllegalArgumentException("minor has to be 0 or positive, but is " + n2);
        }
        if (n3 < 0) {
            throw new IllegalArgumentException("patch has to be 0 or positive, but is " + n3);
        }
        this.major = n;
        this.minor = n2;
        this.patch = n3;
        this.prerelease = prerelease;
        if (bl) {
            this.buildMetaData = indexable.frozen();
            this.buildMetaData.forEach(string -> {
                if (!PATTERN_BUILD_ITEM.matcher((CharSequence)string).matches()) {
                    throw new IllegalArgumentException("Illegal build metadata item: \"" + string + '\"');
                }
            });
        } else {
            this.buildMetaData = indexable;
        }
    }

    @NotNull
    private static Indexable<String> parseBuild(@Nullable String string) {
        if (string == null) {
            return Indexable.emptyIndexable();
        }
        if (!PATTERN_BUILD.matcher(string).matches()) {
            throw new IllegalArgumentException("Illegal build metadata definition: \"" + string + '\"');
        }
        return Indexable.viewArray(SEP_DOT.split(string));
    }

    public int getMajor() {
        return this.major;
    }

    public int getMinor() {
        return this.minor;
    }

    public int getPatch() {
        return this.patch;
    }

    @Nullable
    public Prerelease getPrerelease() {
        return this.prerelease;
    }

    @NotNull
    public Indexable<String> getBuildMetaData() {
        return this.buildMetaData;
    }

    @Nullable
    public String getBuildString() {
        return this.buildMetaData.isEmpty() ? null : Types.join(DOT, this.buildMetaData);
    }

    @NotNull
    public SemVer nextMajor() {
        if (this.major == Integer.MAX_VALUE) {
            throw new ArithmeticException("Major version cannot be increased bcause of integer restrictions!");
        }
        return new SemVer(this.major + 1, 0, 0);
    }

    @NotNull
    public SemVer nextMinor() {
        if (this.minor == Integer.MAX_VALUE) {
            throw new ArithmeticException("Minor version cannot be increased bcause of integer restrictions!");
        }
        return new SemVer(this.major, this.minor + 1, 0);
    }

    @NotNull
    public SemVer nextPatch() {
        if (this.patch == Integer.MAX_VALUE) {
            throw new ArithmeticException("Patch version cannot be increased bcause of integer restrictions!");
        }
        return new SemVer(this.major, this.minor, this.patch + 1);
    }

    @NotNull
    public SemVer withPrerelease(@Nullable Prerelease prerelease) {
        if (this.buildMetaData.isEmpty() && Objects.equals(this.prerelease, prerelease)) {
            return this;
        }
        return new SemVer(this.major, this.minor, this.patch, prerelease);
    }

    @NotNull
    public SemVer withPrereleaseFromString(@Nullable String string) {
        if (string == null) {
            return this.withPrerelease(null);
        }
        Prerelease prerelease = Prerelease.parse(string);
        if (prerelease == null) {
            throw new IllegalArgumentException("Invalid prerelease string: \"" + string + '\"');
        }
        return this.withPrerelease(prerelease);
    }

    @NotNull
    public SemVer withNoBuild() {
        return this.buildMetaData.isEmpty() ? this : new SemVer(this.major, this.minor, this.patch, this.prerelease);
    }

    @NotNull
    public SemVer withBuildString(@NotNull String string) {
        return new SemVer(this.major, this.minor, this.patch, this.prerelease, string);
    }

    public SemVer withBuild(@NotNull Indexable<String> indexable) {
        if (indexable.equals(this.buildMetaData)) {
            return this;
        }
        return new SemVer(this.major, this.minor, this.patch, this.prerelease, indexable, true);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        SemVer semVer = (SemVer)object;
        return this.major == semVer.major && this.minor == semVer.minor && this.patch == semVer.patch && Objects.equals(this.prerelease, semVer.prerelease) && Objects.equals(this.buildMetaData, semVer.buildMetaData);
    }

    public boolean equalsIgnoreBuild(SemVer semVer) {
        if (this == semVer) {
            return true;
        }
        if (semVer == null) {
            return false;
        }
        return this.major == semVer.major && this.minor == semVer.minor && this.patch == semVer.patch && Objects.equals(this.prerelease, semVer.prerelease);
    }

    public int hashCode() {
        return Objects.hash(this.major, this.minor, this.patch, this.prerelease, this.buildMetaData);
    }

    public int hashCodeIgnoreBuild() {
        return Objects.hash(this.major, this.minor, this.patch, this.prerelease);
    }

    @Override
    public int compareTo(@NotNull SemVer semVer) {
        int n = Integer.compare(this.major, semVer.major);
        if (n != 0) {
            return n;
        }
        n = Integer.compare(this.minor, semVer.minor);
        if (n != 0) {
            return n;
        }
        n = Integer.compare(this.patch, semVer.patch);
        if (n != 0) {
            return n;
        }
        if (this.prerelease == null) {
            return semVer.prerelease == null ? 0 : 1;
        }
        return semVer.prerelease == null ? -1 : this.prerelease.compareTo(semVer.prerelease);
    }

    public int compareTo(@NotNull SemVer semVer, @NotNull Comparator<? super Indexable<String>> comparator) {
        int n = this.compareTo(semVer);
        return n != 0 ? n : comparator.compare(this.buildMetaData, semVer.buildMetaData);
    }

    public boolean isNewerThan(@NotNull SemVer semVer) {
        return this.compareTo(semVer) > 0;
    }

    public String toString() {
        String string = this.major + DOT + this.minor + DOT + this.patch;
        if (this.prerelease != null) {
            string = string + "-" + this.prerelease;
        }
        if (!this.buildMetaData.isEmpty()) {
            string = string + '+' + Types.join(DOT, this.buildMetaData);
        }
        return string;
    }

    @Nullable
    public static SemVer parse(@NotNull String string) {
        Matcher matcher = PATTERN.matcher(string);
        if (!matcher.matches()) {
            return null;
        }
        try {
            int n = Integer.parseInt(matcher.group(RE_GRP_MAJOR));
            int n2 = Integer.parseInt(matcher.group(RE_GRP_MINOR));
            int n3 = Integer.parseInt(matcher.group(RE_GRP_PATCH));
            String string2 = matcher.group(RE_GRP_PRERELEASE);
            String string3 = matcher.group(RE_GRP_BUILD);
            Prerelease prerelease = string2 != null ? Prerelease.parseInternal(string2) : null;
            return new SemVer(n, n2, n3, prerelease, string3);
        }
        catch (NumberFormatException numberFormatException) {
            throw new IllegalArgumentException("Version number integer overflow!", numberFormatException);
        }
    }

    public static final class Prerelease
    implements Indexable<Identifier>,
    Comparable<Prerelease> {
        private static final String CONST_ALPHA = "alpha";
        private static final String CONST_BETA = "beta";
        private static final String CONST_RC = "rc";
        public static final Prerelease ALPHA = new Prerelease(new AlphanumericIdentifier("alpha"));
        public static final Prerelease BETA = new Prerelease(new AlphanumericIdentifier("beta"));
        public static final Prerelease RC = new Prerelease(new AlphanumericIdentifier("rc"));
        @NotNull
        private final Indexable<Identifier> parts;

        public Prerelease(@NotNull Identifier identifier) {
            this(Indexable.singleton(identifier));
        }

        private Prerelease(@NotNull Indexable<Identifier> indexable) {
            this.parts = indexable;
        }

        public Prerelease(final @NotNull Identifier identifier, final Identifier ... identifierArray) {
            this(new Indexable.Base<Identifier>(){

                @Override
                public Identifier get(int n) {
                    return n == 0 ? identifier : identifierArray[n - 1];
                }

                @Override
                public int size() {
                    return identifierArray.length + 1;
                }
            }.frozen());
        }

        @Override
        public Identifier get(int n) {
            return this.parts.get(n);
        }

        @Override
        public int size() {
            return this.parts.size();
        }

        @Nullable
        public static Prerelease parse(@NotNull String string) {
            return PATTERN_PRERELEASE.matcher(string).matches() ? Prerelease.parseInternal(string) : null;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null || this.getClass() != object.getClass()) {
                return false;
            }
            Prerelease prerelease = (Prerelease)object;
            return this.parts.equals(prerelease.parts);
        }

        public int hashCode() {
            return Objects.hash(this.parts);
        }

        @Override
        public int compareTo(@NotNull Prerelease prerelease) {
            return Types.lexicalCompare(this.parts, prerelease.parts);
        }

        @NotNull
        public String toString() {
            return Types.join(SemVer.DOT, (Iterable<String>)this.parts.view(Object::toString));
        }

        @NotNull
        private static Prerelease parseInternal(@NotNull String string) {
            int n;
            Identifier[] identifierArray;
            String[] stringArray = SEP_DOT.split(string);
            if (stringArray.length == 1) {
                identifierArray = stringArray[0];
                n = -1;
                switch (identifierArray.hashCode()) {
                    case 92909918: {
                        if (!identifierArray.equals(CONST_ALPHA)) break;
                        n = 0;
                        break;
                    }
                    case 3020272: {
                        if (!identifierArray.equals(CONST_BETA)) break;
                        n = 1;
                        break;
                    }
                    case 3633: {
                        if (!identifierArray.equals(CONST_RC)) break;
                        n = 2;
                    }
                }
                switch (n) {
                    case 0: {
                        return ALPHA;
                    }
                    case 1: {
                        return BETA;
                    }
                    case 2: {
                        return RC;
                    }
                }
            }
            identifierArray = new Identifier[stringArray.length];
            for (n = 0; n < stringArray.length; ++n) {
                String string2 = stringArray[n];
                Matcher matcher = PATTERN_VERSION.matcher(string2);
                if (matcher.matches()) {
                    try {
                        identifierArray[n] = new NumericIdentifier(Integer.parseInt(string2));
                        continue;
                    }
                    catch (NumberFormatException numberFormatException) {
                        Logger.getAnonymousLogger().warning("Switching to alpha-numeric prerelease because integer version is too large: " + string2);
                    }
                }
                identifierArray[n] = new AlphanumericIdentifier(string2);
            }
            return new Prerelease(Indexable.viewArray(identifierArray));
        }

        public static class AlphanumericIdentifier
        implements Identifier {
            @NotNull
            private final String id;

            public AlphanumericIdentifier(@NotNull String string) {
                this.id = string;
            }

            @NotNull
            public String getId() {
                return this.id;
            }

            @Override
            public int compareTo(@NotNull NumericIdentifier numericIdentifier) {
                return 1;
            }

            @Override
            public int compareTo(@NotNull AlphanumericIdentifier alphanumericIdentifier) {
                return this.id.compareTo(alphanumericIdentifier.id);
            }

            @Override
            public int compareTo(@NotNull Identifier identifier) {
                return -identifier.compareTo(this);
            }

            public boolean equals(Object object) {
                if (this == object) {
                    return true;
                }
                if (object == null || this.getClass() != object.getClass()) {
                    return false;
                }
                AlphanumericIdentifier alphanumericIdentifier = (AlphanumericIdentifier)object;
                return this.id.equals(alphanumericIdentifier.id);
            }

            public int hashCode() {
                return Objects.hash(this.id);
            }

            public String toString() {
                return this.id;
            }
        }

        public static class NumericIdentifier
        implements Identifier {
            private final int id;

            public NumericIdentifier(int n) {
                if (n < 0) {
                    throw new IllegalArgumentException("Numeric identifier hss to be non-negative!");
                }
                this.id = n;
            }

            public int getId() {
                return this.id;
            }

            @Override
            public int compareTo(@NotNull NumericIdentifier numericIdentifier) {
                return Integer.compare(this.id, numericIdentifier.id);
            }

            @Override
            public int compareTo(@NotNull AlphanumericIdentifier alphanumericIdentifier) {
                return -1;
            }

            @Override
            public int compareTo(@NotNull Identifier identifier) {
                return -identifier.compareTo(this);
            }

            public boolean equals(Object object) {
                if (this == object) {
                    return true;
                }
                if (object == null || this.getClass() != object.getClass()) {
                    return false;
                }
                NumericIdentifier numericIdentifier = (NumericIdentifier)object;
                return this.id == numericIdentifier.id;
            }

            public int hashCode() {
                return Objects.hash(this.id);
            }

            public String toString() {
                return Integer.toString(this.id);
            }
        }

        public static interface Identifier
        extends Comparable<Identifier> {
            @Override
            public int compareTo(@NotNull NumericIdentifier var1);

            @Override
            public int compareTo(@NotNull AlphanumericIdentifier var1);
        }
    }
}

