/*
 * Decompiled with CFR 0.152.
 */
package de.caff.version;

import de.caff.annotation.NotNull;
import de.caff.annotation.Nullable;
import de.caff.generics.Indexable;
import de.caff.generics.Types;
import de.caff.version.ModuleVersionService;
import de.caff.version.SemVer;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.regex.Pattern;

public final class ModuleVersionTool {
    public static final SimpleDateFormat TIMESTAMP_FORMAT = new SimpleDateFormat("yyyyMMdd-HHmmss");
    public static final String JAVA_SERVICE_TEMPLATE = "// This class is automatically created by %5$s.\n%1$s;\nimport de.caff.annotation.NotNull;\nimport de.caff.generics.Types;\nimport de.caff.version.ModuleVersionService;\nimport de.caff.version.SemVer;\n\nimport java.util.Objects;\n\n/**\n * Module version information.\n * This automatically created class provides version information for the module in which it is contained.\n * Note that creating this class is only the first step, it is necessary to include it in the\n * META-INF/services directory in the module's jar.\n */\npublic class %2$s\n        implements ModuleVersionService\n{\n  /** Module name. */\n  @NotNull\n  public static final String MODULE_NAME = \"%3$s\";\n  /** Module version as a constant. */\n  @NotNull\n  public static final SemVer VERSION = Objects.requireNonNull(SemVer.parse(\"%4$s\"));\n\n  @NotNull\n  @Override\n  public String getModuleName()\n  {\n    return MODULE_NAME;\n  }\n\n  @NotNull\n  @Override\n  public SemVer getModuleVersion()\n  {\n    return VERSION;\n  }\n\n  /**\n   * Get the release date.\n   * This assumes that the release date is included in {@link #VERSION} as build string.\n   * @return build string of the version, empty if there is none\n   */\n  @NotNull\n  public static String getReleaseDate()\n  {\n    return Types.notNull(VERSION.getBuildString());\n  }\n\n  @NotNull\n  @Override\n  public String toString()\n  {\n    return String.format(\"%%s: %%s\", MODULE_NAME, VERSION);\n  }\n}\n";

    private ModuleVersionTool() {
    }

    public static void createJavaImpl(@NotNull String string, @NotNull String string2, @NotNull SemVer semVer, @NotNull Date date, @NotNull File file) throws IOException {
        String string3;
        if (!file.isDirectory()) {
            throw new IOException("Source directory does not exist: " + file);
        }
        Indexable<String> indexable = Indexable.viewArray(string.split(Pattern.quote(".")));
        Indexable<String> indexable2 = indexable.headSet(-1);
        File file2 = file;
        if (!indexable2.isEmpty()) {
            for (String object2 : indexable2) {
                if ((file2 = new File(file2, object2)).exists()) {
                    if (file2.isDirectory()) continue;
                    throw new IOException("Required package directory already exists, but is no directory: " + file2);
                }
                if (file2.mkdir()) continue;
                throw new IOException("Cannot create package directory: " + file2);
            }
            string3 = "package " + Types.join(".", indexable2) + "\n";
        } else {
            string3 = "";
        }
        String string4 = indexable.gyt(-1);
        File file3 = new File(file2, (String)string4 + ".java");
        try (OutputStream outputStream = Files.newOutputStream(file3.toPath(), new OpenOption[0]);){
            outputStream.write(String.format(JAVA_SERVICE_TEMPLATE, string3, string4, string2, semVer.withBuildString(TIMESTAMP_FORMAT.format(date)), ModuleVersionService.class.getTypeName()).getBytes(StandardCharsets.UTF_8));
        }
    }

    @NotNull
    public static SemVer extractFromJavaImpl(@NotNull File file) throws IOException {
        try (BufferedReader bufferedReader = new BufferedReader(new FileReader(file));){
            String string;
            int n = "SemVer.parse(\"".length();
            while ((string = bufferedReader.readLine()) != null) {
                int n2;
                int n3;
                int n4 = string.indexOf("SemVer.parse(\"");
                if (n4 < 0 || (n3 = string.indexOf(34, n2 = n4 + n)) <= 0) continue;
                String string2 = string.substring(n2, n3);
                SemVer semVer = SemVer.parse(string2);
                if (semVer == null) {
                    throw new IOException("Invalid semantic version string: " + string2);
                }
                SemVer semVer2 = semVer;
                return semVer2;
            }
        }
        throw new IOException("No semantic version found!");
    }

    @Nullable
    public static SemVer extractFromJavaImpl(@NotNull String string, @NotNull File file) throws IOException {
        if (!file.isDirectory()) {
            throw new IOException("Source directory does not exist: " + file);
        }
        Indexable<String> indexable = Indexable.viewArray(string.split(Pattern.quote(".")));
        Indexable<String> indexable2 = indexable.headSet(-1);
        File file2 = file;
        for (String string2 : indexable2) {
            if ((file2 = new File(file2, string2)).isDirectory()) continue;
            return null;
        }
        File file3 = new File(file2, indexable.gyt(-1) + ".java");
        if (file3.isFile()) {
            return ModuleVersionTool.extractFromJavaImpl(file3);
        }
        return null;
    }
}

