/*
 * Decompiled with CFR 0.152.
 */
package de.caff.generics.util.combi;

import de.caff.annotation.NotNull;
import de.caff.annotation.Nullable;
import de.caff.generics.BooleanIndexable;
import de.caff.generics.ByteIndexable;
import de.caff.generics.CharIndexable;
import de.caff.generics.Countable;
import de.caff.generics.DoubleIndexable;
import de.caff.generics.FloatIndexable;
import de.caff.generics.Indexable;
import de.caff.generics.IntIndexable;
import de.caff.generics.IteratorConverter;
import de.caff.generics.LongIndexable;
import de.caff.generics.MutableIndexable;
import de.caff.generics.MutableIntIndexable;
import de.caff.generics.ShortIndexable;
import java.math.BigInteger;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.PrimitiveIterator;

public class Permutations<T>
implements Iterable<Indexable<T>> {
    @NotNull
    private final Indexable<T> elements;
    static final Indexable<BigInteger> FIRST_FACTORIALS;
    static final LongIndexable FIRST_FACTORIALS_LONG;

    public Permutations(@NotNull Indexable<T> indexable) {
        this.elements = indexable;
    }

    public Permutations(@NotNull List<T> list) {
        this(Indexable.viewList(list));
    }

    public Permutations(@NotNull Countable<T> countable) {
        this((List<T>)countable.toList());
    }

    public Permutations(@NotNull Collection<T> collection) {
        this(Countable.viewCollection(collection));
    }

    @SafeVarargs
    public Permutations(T ... TArray) {
        this(Indexable.viewArray(TArray));
    }

    @Override
    @NotNull
    public Iterator<Indexable<T>> iterator() {
        return new IteratorConverter<Indexable, IntIndexable>(new RangeIterator(this.elements.size()), intIndexable -> intIndexable.view(this.elements::get));
    }

    @NotNull
    public static BigInteger count(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("Set size of " + n + " is not possible!");
        }
        return Permutations.factorial(n);
    }

    @NotNull
    static BigInteger factorial(int n) {
        if (n < FIRST_FACTORIALS.size()) {
            return FIRST_FACTORIALS.get(n);
        }
        BigInteger bigInteger = FIRST_FACTORIALS.gyt(-1);
        for (int i = FIRST_FACTORIALS.size(); i <= n; ++i) {
            bigInteger = bigInteger.multiply(BigInteger.valueOf(i));
        }
        return bigInteger;
    }

    public static void main(@NotNull String[] stringArray) {
        int n2 = stringArray.length > 0 ? Integer.parseInt(stringArray[0]) : 4;
        Countable countable = IntIndexable.range(65, 65 + n2 - 1).view(n -> Character.toString((char)n));
        HashSet hashSet = new HashSet();
        int n3 = 0;
        for (Indexable indexable : new Permutations(countable)) {
            System.out.println(indexable);
            if (hashSet.contains(indexable)) {
                System.err.printf("Duplicate: %s\n", indexable);
            }
            hashSet.add(indexable);
            ++n3;
        }
        if (n3 != Permutations.factorial(n2).intValue()) {
            System.err.println("Incorrect count!");
        }
    }

    static {
        long[] lArray = new long[21];
        lArray[1] = 1L;
        lArray[0] = 1L;
        for (int i = 2; i < lArray.length; ++i) {
            lArray[i] = lArray[i - 1] * (long)i;
        }
        FIRST_FACTORIALS_LONG = LongIndexable.viewArray(lArray);
        FIRST_FACTORIALS = FIRST_FACTORIALS_LONG.view(BigInteger::valueOf).frozen();
    }

    public static class RangeIterator
    implements Iterator<IntIndexable> {
        @NotNull
        private final MutableIndexable<IndexAndDir> indexes;
        @Nullable
        private MutableIntIndexable nextPermutation;

        public RangeIterator(int n) {
            IntIndexable intIndexable = IntIndexable.rangeFromSize(n);
            this.indexes = MutableIndexable.fromIndexable(intIndexable.view(IndexAndDir::new));
            this.nextPermutation = MutableIntIndexable.fromIndexable(this.indexes, indexAndDir -> indexAndDir.index);
        }

        @Override
        public boolean hasNext() {
            return this.nextPermutation != null;
        }

        @Override
        public IntIndexable next() {
            int n;
            if (this.nextPermutation == null) {
                throw new NoSuchElementException();
            }
            IntIndexable intIndexable = this.nextPermutation.frozen();
            int n2 = -1;
            int n3 = -1;
            int n4 = this.indexes.size();
            for (n = 0; n < n4; ++n) {
                IndexAndDir indexAndDir = (IndexAndDir)this.indexes.get(n);
                int n5 = indexAndDir.index;
                boolean bl = indexAndDir.dir;
                if ((!bl || n >= n4 - 1 || n5 <= ((IndexAndDir)this.indexes.get((int)(n + 1))).index) && (bl || n <= 0 || n5 <= ((IndexAndDir)this.indexes.get((int)(n - 1))).index) || n5 <= n3) continue;
                n3 = n5;
                n2 = n;
            }
            if (n3 < 0) {
                this.nextPermutation = null;
            } else {
                this.indexes.swap(n2, n2 + ((IndexAndDir)this.indexes.get(n2)).getOffset());
                n = 0;
                for (IndexAndDir indexAndDir : this.indexes) {
                    if (indexAndDir.index > n3) {
                        indexAndDir.dir = !indexAndDir.dir;
                    }
                    this.nextPermutation.set(n++, indexAndDir.index);
                }
            }
            return intIndexable;
        }

        private static class IndexAndDir {
            final int index;
            boolean dir;

            IndexAndDir(int n) {
                this.index = n;
                this.dir = false;
            }

            public int getOffset() {
                return this.dir ? 1 : -1;
            }

            public String toString() {
                return String.format("{%d,%s}", this.index, this.dir);
            }
        }
    }

    public static class OfFloat
    implements Iterable<FloatIndexable> {
        @NotNull
        private final FloatIndexable values;

        public OfFloat(@NotNull FloatIndexable floatIndexable) {
            this.values = floatIndexable;
        }

        public OfFloat(float ... fArray) {
            this(FloatIndexable.viewArray(fArray));
        }

        @Override
        public Iterator<FloatIndexable> iterator() {
            return new IteratorConverter<FloatIndexable, IntIndexable>(new RangeIterator(this.values.size()), intIndexable -> new FloatIndexable.Base((IntIndexable)intIndexable){
                final /* synthetic */ IntIndexable val$rangeIdx;
                {
                    this.val$rangeIdx = intIndexable;
                }

                @Override
                public int size() {
                    return this.val$rangeIdx.size();
                }

                @Override
                public float get(int n) {
                    return values.get(this.val$rangeIdx.get(n));
                }
            });
        }
    }

    public static class OfDouble
    implements Iterable<DoubleIndexable> {
        @NotNull
        private final DoubleIndexable values;

        public OfDouble(@NotNull DoubleIndexable doubleIndexable) {
            this.values = doubleIndexable;
        }

        public OfDouble(double ... dArray) {
            this(DoubleIndexable.viewArray(dArray));
        }

        @Override
        public Iterator<DoubleIndexable> iterator() {
            return new IteratorConverter<DoubleIndexable, IntIndexable>(new RangeIterator(this.values.size()), intIndexable -> new DoubleIndexable.Base((IntIndexable)intIndexable){
                final /* synthetic */ IntIndexable val$rangeIdx;
                {
                    this.val$rangeIdx = intIndexable;
                }

                @Override
                public int size() {
                    return this.val$rangeIdx.size();
                }

                @Override
                public double get(int n) {
                    return values.get(this.val$rangeIdx.get(n));
                }
            });
        }
    }

    public static class OfBoolean
    implements Iterable<BooleanIndexable> {
        @NotNull
        private final BooleanIndexable values;

        public OfBoolean(@NotNull BooleanIndexable booleanIndexable) {
            this.values = booleanIndexable;
        }

        public OfBoolean(boolean ... blArray) {
            this(BooleanIndexable.viewArray(blArray));
        }

        @Override
        public Iterator<BooleanIndexable> iterator() {
            return new IteratorConverter<BooleanIndexable, IntIndexable>(new RangeIterator(this.values.size()), intIndexable -> new BooleanIndexable.Base((IntIndexable)intIndexable){
                final /* synthetic */ IntIndexable val$rangeIdx;
                {
                    this.val$rangeIdx = intIndexable;
                }

                @Override
                public int size() {
                    return this.val$rangeIdx.size();
                }

                @Override
                public boolean get(int n) {
                    return values.get(this.val$rangeIdx.get(n));
                }
            });
        }
    }

    public static class OfString
    implements Iterable<String> {
        @NotNull
        private final CharSequence str;

        public OfString(@NotNull CharSequence charSequence) {
            this.str = charSequence;
        }

        @Override
        public Iterator<String> iterator() {
            int n = this.str.length();
            return new IteratorConverter<String, IntIndexable>(new RangeIterator(n), intIndexable -> {
                StringBuilder stringBuilder = new StringBuilder(n);
                PrimitiveIterator.OfInt ofInt = intIndexable.intIterator();
                while (ofInt.hasNext()) {
                    int n2 = ofInt.nextInt();
                    stringBuilder.append(this.str.charAt(n2));
                }
                return stringBuilder.toString();
            });
        }
    }

    public static class OfChar
    implements Iterable<CharIndexable> {
        @NotNull
        private final CharIndexable values;

        public OfChar(@NotNull CharIndexable charIndexable) {
            this.values = charIndexable;
        }

        public OfChar(char ... cArray) {
            this(CharIndexable.viewArray(cArray));
        }

        public OfChar(@NotNull String string) {
            this(CharIndexable.viewString(string));
        }

        @Override
        public Iterator<CharIndexable> iterator() {
            return new IteratorConverter<CharIndexable, IntIndexable>(new RangeIterator(this.values.size()), intIndexable -> new CharIndexable.Base((IntIndexable)intIndexable){
                final /* synthetic */ IntIndexable val$rangeIdx;
                {
                    this.val$rangeIdx = intIndexable;
                }

                @Override
                public int size() {
                    return this.val$rangeIdx.size();
                }

                @Override
                public char get(int n) {
                    return values.get(this.val$rangeIdx.get(n));
                }
            });
        }
    }

    public static class OfShort
    implements Iterable<ShortIndexable> {
        @NotNull
        private final ShortIndexable values;

        public OfShort(@NotNull ShortIndexable shortIndexable) {
            this.values = shortIndexable;
        }

        public OfShort(short ... sArray) {
            this(ShortIndexable.viewArray(sArray));
        }

        @Override
        public Iterator<ShortIndexable> iterator() {
            return new IteratorConverter<ShortIndexable, IntIndexable>(new RangeIterator(this.values.size()), intIndexable -> new ShortIndexable.Base((IntIndexable)intIndexable){
                final /* synthetic */ IntIndexable val$rangeIdx;
                {
                    this.val$rangeIdx = intIndexable;
                }

                @Override
                public int size() {
                    return this.val$rangeIdx.size();
                }

                @Override
                public short get(int n) {
                    return values.get(this.val$rangeIdx.get(n));
                }
            });
        }
    }

    public static class OfLong
    implements Iterable<LongIndexable> {
        @NotNull
        private final LongIndexable values;

        public OfLong(@NotNull LongIndexable longIndexable) {
            this.values = longIndexable;
        }

        public OfLong(long ... lArray) {
            this(LongIndexable.viewArray(lArray));
        }

        @Override
        public Iterator<LongIndexable> iterator() {
            return new IteratorConverter<LongIndexable, IntIndexable>(new RangeIterator(this.values.size()), intIndexable -> new LongIndexable.Base((IntIndexable)intIndexable){
                final /* synthetic */ IntIndexable val$rangeIdx;
                {
                    this.val$rangeIdx = intIndexable;
                }

                @Override
                public int size() {
                    return this.val$rangeIdx.size();
                }

                @Override
                public long get(int n) {
                    return values.get(this.val$rangeIdx.get(n));
                }
            });
        }
    }

    public static class OfByte
    implements Iterable<ByteIndexable> {
        @NotNull
        private final ByteIndexable values;

        public OfByte(@NotNull ByteIndexable byteIndexable) {
            this.values = byteIndexable;
        }

        public OfByte(byte ... byArray) {
            this(ByteIndexable.viewArray(byArray));
        }

        @Override
        public Iterator<ByteIndexable> iterator() {
            return new IteratorConverter<ByteIndexable, IntIndexable>(new RangeIterator(this.values.size()), intIndexable -> new ByteIndexable.Base((IntIndexable)intIndexable){
                final /* synthetic */ IntIndexable val$rangeIdx;
                {
                    this.val$rangeIdx = intIndexable;
                }

                @Override
                public int size() {
                    return this.val$rangeIdx.size();
                }

                @Override
                public byte get(int n) {
                    return values.get(this.val$rangeIdx.get(n));
                }
            });
        }
    }

    public static class OfInt
    implements Iterable<IntIndexable> {
        @NotNull
        private final IntIndexable values;

        public OfInt(@NotNull IntIndexable intIndexable) {
            this.values = intIndexable;
        }

        public OfInt(int ... nArray) {
            this(IntIndexable.viewArray(nArray));
        }

        @Override
        public Iterator<IntIndexable> iterator() {
            return new IteratorConverter<IntIndexable, IntIndexable>(new RangeIterator(this.values.size()), intIndexable -> new IntIndexable.Base((IntIndexable)intIndexable){
                final /* synthetic */ IntIndexable val$rangeIdx;
                {
                    this.val$rangeIdx = intIndexable;
                }

                @Override
                public int size() {
                    return this.val$rangeIdx.size();
                }

                @Override
                public int get(int n) {
                    return values.get(this.val$rangeIdx.get(n));
                }
            });
        }
    }

    public static class OfRange
    implements Iterable<IntIndexable> {
        private final int size;

        public OfRange(int n) {
            if (n < 0) {
                throw new IllegalArgumentException("size has to be non-negative!");
            }
            this.size = n;
        }

        public int getSize() {
            return this.size;
        }

        @Override
        public Iterator<IntIndexable> iterator() {
            return new RangeIterator(this.size);
        }
    }
}

