/*
 * Decompiled with CFR 0.152.
 */
package de.caff.generics.util.combi;

import de.caff.annotation.NotNull;
import de.caff.generics.Indexable;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Stack;

public class IntPartitions {
    @NotNull
    public static Iterable<Partition> of(int n) {
        if (n <= 0) {
            throw new IllegalArgumentException("Cannot only create partitions for positive values, not " + n);
        }
        return () -> new IntPartitionIterator(n);
    }

    public static void main(@NotNull String[] stringArray) {
        if (stringArray.length == 0) {
            System.err.println("Need at least one number!");
            System.exit(1);
        }
        for (String string : stringArray) {
            System.out.printf("%s:\n", string);
            int n = Integer.parseInt(string);
            for (Indexable indexable : IntPartitions.of(n)) {
                System.out.println(indexable);
            }
            System.out.println();
        }
    }

    private static class IntPartitionIterator
    implements Iterator<Partition> {
        private final Stack<Unit> stack = new Stack();
        private boolean hasNext = true;

        private IntPartitionIterator(int n) {
            this.stack.push(new Unit(n, 1));
        }

        @Override
        public boolean hasNext() {
            return this.hasNext;
        }

        @Override
        public Partition next() {
            if (!this.hasNext) {
                throw new NoSuchElementException("No more partitions left!");
            }
            Partition partition = new Partition(this.stack);
            this.hasNext = this.prepareNext();
            return partition;
        }

        private boolean prepareNext() {
            int n;
            int n2;
            Unit unit;
            if (((Unit)this.stack.get((int)0)).number == 1) {
                return false;
            }
            int n3 = 0;
            while (true) {
                unit = this.stack.peek();
                n3 += unit.number;
                --unit.count;
                n2 = unit.number - 1;
                if (n2 != 0) break;
                n3 += unit.count;
                this.stack.pop();
            }
            if (unit.count == 0) {
                this.stack.pop();
            }
            if ((n = n3 / n2) != 0) {
                this.stack.push(new Unit(n2, n));
                if ((n3 -= n2 * n) == 0) {
                    return true;
                }
            }
            this.stack.push(new Unit(n3, 1));
            return true;
        }

        private static class Unit {
            int number;
            int count;

            Unit(int n, int n2) {
                this.number = n;
                this.count = n2;
            }

            @NotNull
            Part part() {
                return new Part(this.number, this.count);
            }
        }
    }

    public static class Partition
    implements Indexable<Part> {
        @NotNull
        private final Part[] parts;
        private final int sumOfCounts;

        private Partition(@NotNull Stack<IntPartitionIterator.Unit> stack) {
            this.parts = new Part[stack.size()];
            int n = 0;
            int n2 = 0;
            for (IntPartitionIterator.Unit unit : stack) {
                this.parts[n++] = unit.part();
                n2 += unit.count;
            }
            this.sumOfCounts = n2;
        }

        public int getSumOfCounts() {
            return this.sumOfCounts;
        }

        @Override
        public Part get(int n) {
            return this.parts[n];
        }

        @Override
        public int size() {
            return this.parts.length;
        }

        @NotNull
        public Partition frozen() {
            return this;
        }
    }

    public static class Part {
        public final int number;
        public final int count;

        Part(int n, int n2) {
            this.number = n;
            this.count = n2;
        }

        public int getNumber() {
            return this.number;
        }

        public int getCount() {
            return this.count;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (!(object instanceof Part)) {
                return false;
            }
            Part part = (Part)object;
            return this.number == part.number && this.count == part.count;
        }

        public int hashCode() {
            return Objects.hash(this.number, this.count);
        }

        public String toString() {
            return String.format("%d*%d", this.count, this.number);
        }
    }
}

