/*
 * Decompiled with CFR 0.152.
 */
package de.caff.generics.util.combi;

import de.caff.annotation.NotNull;
import de.caff.generics.BooleanIndexable;
import de.caff.generics.ByteIndexable;
import de.caff.generics.CharIndexable;
import de.caff.generics.Countable;
import de.caff.generics.DoubleIndexable;
import de.caff.generics.FloatIndexable;
import de.caff.generics.Indexable;
import de.caff.generics.IntIndexable;
import de.caff.generics.IteratorConverter;
import de.caff.generics.LongIndexable;
import de.caff.generics.ShortIndexable;
import de.caff.generics.SingletonIterator;
import de.caff.generics.util.combi.Permutations;
import java.math.BigInteger;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.PrimitiveIterator;

public class Combinations<T>
implements Iterable<Indexable<T>> {
    @NotNull
    private final Indexable<T> elements;
    private final int k;

    public Combinations(int n, @NotNull Indexable<T> indexable) {
        Combinations.checkBinomial(indexable.size(), n);
        this.elements = indexable;
        this.k = n;
    }

    public Combinations(int n, @NotNull List<T> list) {
        this(n, Indexable.viewList(list));
    }

    public Combinations(int n, @NotNull Countable<T> countable) {
        this(n, (List<T>)countable.toList());
    }

    public Combinations(int n, @NotNull Collection<T> collection) {
        this(n, Countable.viewCollection(collection));
    }

    @SafeVarargs
    public Combinations(int n, T ... TArray) {
        this(n, Indexable.viewArray(TArray));
    }

    @Override
    @NotNull
    public Iterator<Indexable<T>> iterator() {
        return new IteratorConverter<Indexable, IntIndexable>(Combinations.createRangeIterator(this.elements.size(), this.k), intIndexable -> intIndexable.view(this.elements::get));
    }

    @NotNull
    public static Iterator<IntIndexable> createRangeIterator(int n, int n2) {
        if (n < 0) {
            throw new IllegalArgumentException("n has to be non-negative!");
        }
        if (n2 < 0 || n2 > n) {
            throw new IllegalArgumentException(String.format("k has to be >=0 and <= %d, but is %d!", n, n2));
        }
        if (n2 == 0) {
            return new SingletonIterator<IntIndexable>(IntIndexable.EMPTY);
        }
        if (n2 == n) {
            return new SingletonIterator<IntIndexable>(IntIndexable.rangeFromSize(n));
        }
        return new RangeIterator(n, n2);
    }

    static void checkBinomial(int n, int n2) {
        if (n < 0) {
            throw new IllegalArgumentException(String.format("n must not be negative, but is %d!", n));
        }
        if (n2 < 0 || n2 > n) {
            throw new IllegalArgumentException(String.format("k has to be >=0 and <= %d, but is %d!", n, n2));
        }
    }

    @NotNull
    public static BigInteger count(int n, int n2) {
        Combinations.checkBinomial(n, n2);
        if (n2 == 0 || n2 == n) {
            return BigInteger.ONE;
        }
        if (n < Permutations.FIRST_FACTORIALS_LONG.size()) {
            LongIndexable longIndexable = Permutations.FIRST_FACTORIALS_LONG;
            return BigInteger.valueOf(longIndexable.get(n) / (longIndexable.get(n2) * longIndexable.get(n - n2)));
        }
        if ((n + (n2 = Math.max(n2, n - n2))) / 2 < Permutations.FIRST_FACTORIALS.size()) {
            return Permutations.factorial(n).divide(Permutations.factorial(n2).multiply(Permutations.factorial(n - n2)));
        }
        BigInteger bigInteger = BigInteger.ONE;
        for (int i = n2 + 1; i <= n; ++i) {
            bigInteger = bigInteger.multiply(BigInteger.valueOf(i));
        }
        return bigInteger.divide(Permutations.factorial(n - n2));
    }

    public static void main(String[] stringArray) {
        int n = 0;
        HashSet<String> hashSet = new HashSet<String>();
        for (String string : new OfString(5, "0123456789")) {
            System.out.println(string);
            if (hashSet.contains(string)) {
                System.err.printf("Duplicate: %s\n", string);
            }
            hashSet.add(string);
            ++n;
        }
        if (n != Combinations.count(10, 5).intValue()) {
            System.err.println("Incorrect!");
        }
    }

    private static class RangeIterator
    implements Iterator<IntIndexable> {
        @NotNull
        private final int[] c;
        private final int k;
        private int j;
        private boolean goOn = true;

        RangeIterator(int n, int n2) {
            this.k = n2;
            this.c = new int[n2 + 3];
            for (int i = 1; i <= n2; ++i) {
                this.c[i] = i - 1;
            }
            this.c[n2 + 1] = n;
            this.c[n2 + 2] = 0;
            this.j = n2;
        }

        @Override
        public boolean hasNext() {
            return this.goOn;
        }

        @Override
        @NotNull
        public IntIndexable next() {
            if (!this.goOn) {
                throw new NoSuchElementException();
            }
            IntIndexable intIndexable = IntIndexable.viewArray(this.c, 1, this.k).frozen();
            int n = 0;
            if (this.j > 0) {
                this.c[this.j] = n = this.j;
                --this.j;
                return intIndexable;
            }
            if (this.c[1] + 1 < this.c[2]) {
                this.c[1] = this.c[1] + 1;
                return intIndexable;
            }
            this.j = 2;
            while (true) {
                this.c[this.j - 1] = this.j - 2;
                n = this.c[this.j] + 1;
                if (n != this.c[this.j + 1]) break;
                ++this.j;
            }
            if (this.j > this.k) {
                this.goOn = false;
                return intIndexable;
            }
            this.c[this.j] = n;
            --this.j;
            return intIndexable;
        }
    }

    public static class OfFloat
    implements Iterable<FloatIndexable> {
        private final int k;
        @NotNull
        private final FloatIndexable values;

        public OfFloat(int n, @NotNull FloatIndexable floatIndexable) {
            Combinations.checkBinomial(floatIndexable.size(), n);
            this.k = n;
            this.values = floatIndexable;
        }

        public OfFloat(int n, float ... fArray) {
            this(n, FloatIndexable.viewArray(fArray));
        }

        @Override
        public Iterator<FloatIndexable> iterator() {
            return new IteratorConverter<FloatIndexable, IntIndexable>(Combinations.createRangeIterator(this.values.size(), this.k), intIndexable -> new FloatIndexable.Base((IntIndexable)intIndexable){
                final /* synthetic */ IntIndexable val$rangeIdx;
                {
                    this.val$rangeIdx = intIndexable;
                }

                @Override
                public int size() {
                    return this.val$rangeIdx.size();
                }

                @Override
                public float get(int n) {
                    return values.get(this.val$rangeIdx.get(n));
                }
            });
        }
    }

    public static class OfDouble
    implements Iterable<DoubleIndexable> {
        private final int k;
        @NotNull
        private final DoubleIndexable values;

        public OfDouble(int n, @NotNull DoubleIndexable doubleIndexable) {
            Combinations.checkBinomial(doubleIndexable.size(), n);
            this.k = n;
            this.values = doubleIndexable;
        }

        public OfDouble(int n, double ... dArray) {
            this(n, DoubleIndexable.viewArray(dArray));
        }

        @Override
        public Iterator<DoubleIndexable> iterator() {
            return new IteratorConverter<DoubleIndexable, IntIndexable>(Combinations.createRangeIterator(this.values.size(), this.k), intIndexable -> new DoubleIndexable.Base((IntIndexable)intIndexable){
                final /* synthetic */ IntIndexable val$rangeIdx;
                {
                    this.val$rangeIdx = intIndexable;
                }

                @Override
                public int size() {
                    return this.val$rangeIdx.size();
                }

                @Override
                public double get(int n) {
                    return values.get(this.val$rangeIdx.get(n));
                }
            });
        }
    }

    public static class OfBoolean
    implements Iterable<BooleanIndexable> {
        private final int k;
        @NotNull
        private final BooleanIndexable values;

        public OfBoolean(int n, @NotNull BooleanIndexable booleanIndexable) {
            Combinations.checkBinomial(booleanIndexable.size(), n);
            this.k = n;
            this.values = booleanIndexable;
        }

        public OfBoolean(int n, boolean ... blArray) {
            this(n, BooleanIndexable.viewArray(blArray));
        }

        @Override
        public Iterator<BooleanIndexable> iterator() {
            return new IteratorConverter<BooleanIndexable, IntIndexable>(Combinations.createRangeIterator(this.values.size(), this.k), intIndexable -> new BooleanIndexable.Base((IntIndexable)intIndexable){
                final /* synthetic */ IntIndexable val$rangeIdx;
                {
                    this.val$rangeIdx = intIndexable;
                }

                @Override
                public int size() {
                    return this.val$rangeIdx.size();
                }

                @Override
                public boolean get(int n) {
                    return values.get(this.val$rangeIdx.get(n));
                }
            });
        }
    }

    public static class OfString
    implements Iterable<String> {
        private final int k;
        @NotNull
        private final CharSequence str;

        public OfString(int n, @NotNull CharSequence charSequence) {
            Combinations.checkBinomial(charSequence.length(), n);
            this.k = n;
            this.str = charSequence;
        }

        @Override
        public Iterator<String> iterator() {
            return new IteratorConverter<String, IntIndexable>(Combinations.createRangeIterator(this.str.length(), this.k), intIndexable -> {
                StringBuilder stringBuilder = new StringBuilder(this.k);
                PrimitiveIterator.OfInt ofInt = intIndexable.intIterator();
                while (ofInt.hasNext()) {
                    int n = ofInt.nextInt();
                    stringBuilder.append(this.str.charAt(n));
                }
                return stringBuilder.toString();
            });
        }
    }

    public static class OfChar
    implements Iterable<CharIndexable> {
        private final int k;
        @NotNull
        private final CharIndexable values;

        public OfChar(int n, @NotNull CharIndexable charIndexable) {
            Combinations.checkBinomial(charIndexable.size(), n);
            this.k = n;
            this.values = charIndexable;
        }

        public OfChar(int n, char ... cArray) {
            this(n, CharIndexable.viewArray(cArray));
        }

        public OfChar(int n, @NotNull String string) {
            this(n, CharIndexable.viewString(string));
        }

        @Override
        public Iterator<CharIndexable> iterator() {
            return new IteratorConverter<CharIndexable, IntIndexable>(Combinations.createRangeIterator(this.values.size(), this.k), intIndexable -> new CharIndexable.Base((IntIndexable)intIndexable){
                final /* synthetic */ IntIndexable val$rangeIdx;
                {
                    this.val$rangeIdx = intIndexable;
                }

                @Override
                public int size() {
                    return this.val$rangeIdx.size();
                }

                @Override
                public char get(int n) {
                    return values.get(this.val$rangeIdx.get(n));
                }
            });
        }
    }

    public static class OfShort
    implements Iterable<ShortIndexable> {
        private final int k;
        @NotNull
        private final ShortIndexable values;

        public OfShort(int n, @NotNull ShortIndexable shortIndexable) {
            Combinations.checkBinomial(shortIndexable.size(), n);
            this.k = n;
            this.values = shortIndexable;
        }

        public OfShort(int n, short ... sArray) {
            this(n, ShortIndexable.viewArray(sArray));
        }

        @Override
        public Iterator<ShortIndexable> iterator() {
            return new IteratorConverter<ShortIndexable, IntIndexable>(Combinations.createRangeIterator(this.values.size(), this.k), intIndexable -> new ShortIndexable.Base((IntIndexable)intIndexable){
                final /* synthetic */ IntIndexable val$rangeIdx;
                {
                    this.val$rangeIdx = intIndexable;
                }

                @Override
                public int size() {
                    return this.val$rangeIdx.size();
                }

                @Override
                public short get(int n) {
                    return values.get(this.val$rangeIdx.get(n));
                }
            });
        }
    }

    public static class OfLong
    implements Iterable<LongIndexable> {
        private final int k;
        @NotNull
        private final LongIndexable values;

        public OfLong(int n, @NotNull LongIndexable longIndexable) {
            Combinations.checkBinomial(longIndexable.size(), n);
            this.k = n;
            this.values = longIndexable;
        }

        public OfLong(int n, long ... lArray) {
            this(n, LongIndexable.viewArray(lArray));
        }

        @Override
        public Iterator<LongIndexable> iterator() {
            return new IteratorConverter<LongIndexable, IntIndexable>(Combinations.createRangeIterator(this.values.size(), this.k), intIndexable -> new LongIndexable.Base((IntIndexable)intIndexable){
                final /* synthetic */ IntIndexable val$rangeIdx;
                {
                    this.val$rangeIdx = intIndexable;
                }

                @Override
                public int size() {
                    return this.val$rangeIdx.size();
                }

                @Override
                public long get(int n) {
                    return values.get(this.val$rangeIdx.get(n));
                }
            });
        }
    }

    public static class OfByte
    implements Iterable<ByteIndexable> {
        private final int k;
        @NotNull
        private final ByteIndexable values;

        public OfByte(int n, @NotNull ByteIndexable byteIndexable) {
            Combinations.checkBinomial(byteIndexable.size(), n);
            this.k = n;
            this.values = byteIndexable;
        }

        public OfByte(int n, byte ... byArray) {
            this(n, ByteIndexable.viewArray(byArray));
        }

        @Override
        public Iterator<ByteIndexable> iterator() {
            return new IteratorConverter<ByteIndexable, IntIndexable>(Combinations.createRangeIterator(this.values.size(), this.k), intIndexable -> new ByteIndexable.Base((IntIndexable)intIndexable){
                final /* synthetic */ IntIndexable val$rangeIdx;
                {
                    this.val$rangeIdx = intIndexable;
                }

                @Override
                public int size() {
                    return this.val$rangeIdx.size();
                }

                @Override
                public byte get(int n) {
                    return values.get(this.val$rangeIdx.get(n));
                }
            });
        }
    }

    public static class OfInt
    implements Iterable<IntIndexable> {
        private final int k;
        @NotNull
        private final IntIndexable values;

        public OfInt(int n, @NotNull IntIndexable intIndexable) {
            Combinations.checkBinomial(intIndexable.size(), n);
            this.k = n;
            this.values = intIndexable;
        }

        public OfInt(int n, int ... nArray) {
            this(n, IntIndexable.viewArray(nArray));
        }

        @Override
        public Iterator<IntIndexable> iterator() {
            return new IteratorConverter<IntIndexable, IntIndexable>(Combinations.createRangeIterator(this.values.size(), this.k), intIndexable -> new IntIndexable.Base((IntIndexable)intIndexable){
                final /* synthetic */ IntIndexable val$rangeIdx;
                {
                    this.val$rangeIdx = intIndexable;
                }

                @Override
                public int size() {
                    return this.val$rangeIdx.size();
                }

                @Override
                public int get(int n) {
                    return values.get(this.val$rangeIdx.get(n));
                }
            });
        }
    }

    public static class OfRange
    implements Iterable<IntIndexable> {
        private final int k;
        private final int n;

        public OfRange(int n, int n2) {
            Combinations.checkBinomial(n, n2);
            this.n = n;
            this.k = n2;
        }

        public int getSize() {
            return this.n;
        }

        @Override
        @NotNull
        public Iterator<IntIndexable> iterator() {
            return Combinations.createRangeIterator(this.n, this.k);
        }
    }
}

