/*
 * Decompiled with CFR 0.152.
 */
package de.caff.generics.util;

import de.caff.annotation.NotNull;
import de.caff.generics.util.LongCounter;
import java.util.concurrent.atomic.AtomicLong;

public final class ThreadSafeLongCounter
implements LongCounter {
    private final AtomicLong value;

    public ThreadSafeLongCounter() {
        this.value = new AtomicLong();
    }

    public ThreadSafeLongCounter(int n) {
        this.value = new AtomicLong(n);
    }

    public ThreadSafeLongCounter(@NotNull LongCounter longCounter) {
        this.value = new AtomicLong(longCounter.getValue());
    }

    @Override
    public long add(long l) {
        return this.value.addAndGet(l);
    }

    @Override
    public long add(@NotNull LongCounter longCounter) {
        return this.add(longCounter.getValue());
    }

    @Override
    public long add1() {
        return this.add(1L);
    }

    @Override
    public long subtract(long l) {
        return this.add(-l);
    }

    @Override
    public long subtract(@NotNull LongCounter longCounter) {
        return this.add(-longCounter.getValue());
    }

    @Override
    public long subtract1() {
        return this.add(-1L);
    }

    @Override
    public long getValue() {
        return this.value.get();
    }

    @Override
    public void setValue(long l) {
        this.value.set(l);
    }

    @NotNull
    public String toString() {
        return Long.toString(this.value.get());
    }
}

