/*
 * Decompiled with CFR 0.152.
 */
package de.caff.generics.util;

import de.caff.annotation.NotNull;
import de.caff.generics.util.Counter;
import java.util.concurrent.atomic.AtomicInteger;

public final class ThreadSafeCounter
implements Counter {
    private final AtomicInteger value;

    public ThreadSafeCounter() {
        this.value = new AtomicInteger();
    }

    public ThreadSafeCounter(int n) {
        this.value = new AtomicInteger(n);
    }

    public ThreadSafeCounter(@NotNull Counter counter) {
        this.value = new AtomicInteger(counter.getValue());
    }

    @Override
    public int add(int n) {
        return this.value.addAndGet(n);
    }

    @Override
    public int add(@NotNull Counter counter) {
        return this.add(counter.getValue());
    }

    @Override
    public int add1() {
        return this.add(1);
    }

    @Override
    public int subtract(int n) {
        return this.add(-n);
    }

    @Override
    public int subtract(@NotNull Counter counter) {
        return this.add(-counter.getValue());
    }

    @Override
    public int subtract1() {
        return this.add(-1);
    }

    @Override
    public int getValue() {
        return this.value.get();
    }

    @Override
    public void setValue(int n) {
        this.value.set(n);
    }

    public String toString() {
        return Integer.toString(this.value.get());
    }
}

