/*
 * Decompiled with CFR 0.152.
 */
package de.caff.generics.util;

import de.caff.annotation.NotNull;
import de.caff.generics.util.HardReferenceImpl;
import de.caff.generics.util.IReference;
import de.caff.generics.util.SoftReferenceImpl;
import de.caff.generics.util.WeakReferenceImpl;

public enum ReferenceType {
    Hard(HardReferenceImpl::new),
    Soft(SoftReferenceImpl::new),
    Weak(WeakReferenceImpl::new);

    private final ReferenceCreator referenceCreator;

    private ReferenceType(ReferenceCreator referenceCreator) {
        this.referenceCreator = referenceCreator;
    }

    @NotNull
    public <T> IReference<T> makeReference(@NotNull T t) {
        return this.referenceCreator.makeReference(t);
    }

    private static interface ReferenceCreator {
        @NotNull
        public <T> IReference<T> makeReference(@NotNull T var1);
    }
}

