/*
 * Decompiled with CFR 0.152.
 */
package de.caff.generics.util;

import de.caff.annotation.NotNull;
import de.caff.annotation.Nullable;
import de.caff.generics.util.HardReferenceImpl;
import de.caff.generics.util.SoftReferenceImpl;
import de.caff.generics.util.WeakReferenceImpl;

@FunctionalInterface
public interface IReference<T> {
    public static final IReference<?> NULL_REF = new IReference<Object>(){

        @Override
        @Nullable
        public Object get() {
            return null;
        }

        @Override
        public boolean isNull() {
            return true;
        }
    };

    @Nullable
    public T get();

    default public boolean isNull() {
        return this == NULL_REF;
    }

    @NotNull
    public static <R> IReference<R> nullRef() {
        return NULL_REF;
    }

    @NotNull
    public static <R> IReference<R> hard(@Nullable R r) {
        return r == null ? IReference.nullRef() : new HardReferenceImpl<R>(r);
    }

    @NotNull
    public static <R> IReference<R> soft(@Nullable R r) {
        return r == null ? IReference.nullRef() : new SoftReferenceImpl<R>(r);
    }

    @NotNull
    public static <R> IReference<R> weak(@Nullable R r) {
        return r == null ? IReference.nullRef() : new WeakReferenceImpl<R>(r);
    }
}

