/*
 * Decompiled with CFR 0.152.
 */
package de.caff.generics.util;

import de.caff.annotation.NotNull;
import de.caff.generics.util.SimpleCounter;
import de.caff.generics.util.ThreadSafeCounter;
import java.util.function.Supplier;

public interface Counter {
    public static final Supplier<Counter> SIMPLE = SimpleCounter::new;
    public static final Supplier<Counter> THREAD_SAFE = ThreadSafeCounter::new;

    public int add(int var1);

    public int add(@NotNull Counter var1);

    default public int add(@NotNull Number number) {
        return this.add(number.intValue());
    }

    public int add1();

    public int subtract(int var1);

    @Deprecated
    default public int substract(int n) {
        return this.subtract(n);
    }

    public int subtract(@NotNull Counter var1);

    @Deprecated
    default public int substract(@NotNull Counter counter) {
        return this.subtract(counter);
    }

    default public int subtract(@NotNull Number number) {
        return this.subtract(number.intValue());
    }

    public int subtract1();

    @Deprecated
    default public int substract1() {
        return this.subtract1();
    }

    public int getValue();

    public void setValue(int var1);

    @NotNull
    public static Counter simple() {
        return SIMPLE.get();
    }

    @NotNull
    public static Counter simple(int n) {
        Counter counter = Counter.simple();
        counter.setValue(n);
        return counter;
    }

    @NotNull
    public static Counter threadSafe() {
        return THREAD_SAFE.get();
    }

    @NotNull
    public static Counter threadSafe(int n) {
        Counter counter = Counter.threadSafe();
        counter.setValue(n);
        return counter;
    }

    @FunctionalInterface
    @Deprecated
    public static interface Creator
    extends Supplier<Counter> {
        @Override
        default public Counter get() {
            return this.create();
        }

        @NotNull
        public Counter create();
    }
}

