/*
 * Decompiled with CFR 0.152.
 */
package de.caff.generics.util;

import de.caff.annotation.NotNull;
import de.caff.annotation.Nullable;
import de.caff.generics.Copyable;
import de.caff.generics.util.IReference;
import java.util.function.UnaryOperator;

public class CopyRef<T extends Copyable<T>>
implements IReference<T> {
    @NotNull
    private final UnaryOperator<T> copier;
    @NotNull
    private final T object;

    public CopyRef(@NotNull T t, @NotNull UnaryOperator<T> unaryOperator) {
        this.object = (Copyable)t.getCopy();
        this.copier = unaryOperator;
    }

    @Override
    @NotNull
    public T get() {
        return (T)((Copyable)this.copier.apply(this.object));
    }

    @NotNull
    public <R extends Copyable<R>> CopyRef<R> make(@NotNull R r) {
        return new CopyRef<R>(r, Copyable::getCopy);
    }

    @NotNull
    public <R extends Copyable<R>> IReference<R> makeN(@Nullable R r) {
        return r == null ? IReference.nullRef() : this.make(r);
    }
}

