/*
 * Decompiled with CFR 0.152.
 */
package de.caff.generics.range;

import de.caff.annotation.NotNull;
import de.caff.generics.PrimitiveIntIterable;
import de.caff.generics.PrimitiveLongIterable;
import de.caff.generics.Sizeable;
import java.util.Collection;
import java.util.NoSuchElementException;
import java.util.PrimitiveIterator;

public class Range {
    private Range() {
    }

    @NotNull
    public static PrimitiveIntIterable of(final int n, int n2, final int n3) {
        if (n3 == 0) {
            throw new IllegalArgumentException("Not a valid step size: 0");
        }
        if (n2 < n && n3 > 0) {
            throw new IllegalArgumentException(String.format("Cannot step forward through backward range: %d..%d with step %d", n, n2, n3));
        }
        if (n2 > n && n3 < 0) {
            throw new IllegalArgumentException(String.format("Cannot step backward through forward range: %d..%d with step %d", n, n2, n3));
        }
        final int n4 = Math.abs(n3) == 1 ? n2 : (int)(((long)n2 - (long)n) / (long)n3 * (long)n3) + n;
        return () -> new PrimitiveIterator.OfInt(){
            private int next;
            boolean running;
            {
                this.next = n;
                this.running = true;
            }

            @Override
            public int nextInt() {
                if (!this.running) {
                    throw new NoSuchElementException("Iterator was already at its end!");
                }
                int n2 = this.next;
                if (n2 == n4) {
                    this.running = false;
                } else {
                    this.next += n3;
                }
                return n2;
            }

            @Override
            public boolean hasNext() {
                return this.running;
            }
        };
    }

    @NotNull
    public static PrimitiveIntIterable of(int n, int n2) {
        return n <= n2 ? Range.of(n, n2, 1) : Range.of(n, n2, -1);
    }

    @NotNull
    public static PrimitiveLongIterable of(final long l, long l2, final long l3) {
        long l4;
        if (l3 == 0L) {
            throw new IllegalArgumentException("Not a valid step size: 0");
        }
        if (l2 < l && l3 > 0L) {
            throw new IllegalArgumentException(String.format("Cannot step forward through backward range: %d..%d with step %d", l, l2, l3));
        }
        if (l2 > l && l3 < 0L) {
            throw new IllegalArgumentException(String.format("Cannot step backward through forward range: %d..%d with step %d", l, l2, l3));
        }
        if (Math.abs(l3) == 1L) {
            l4 = l2;
        } else if (l3 > 0L) {
            if (l < 0L && l2 >= 0L) {
                long l5 = (-1L - l) % l3;
                long l6 = -1L + l3 - l5;
                l4 = l5 > l2 ? -1L - l5 : (l2 - l6) / l3 * l3 + l6;
            } else {
                l4 = (l2 - l) / l3 * l3 + l;
            }
        } else {
            long l7;
            long l8;
            l4 = l2 < 0L && l >= 0L ? ((l8 = (l7 = l % l3) + l3) < l2 ? l7 : (l2 - l8) / l3 * l3 + l8) : (l2 - l) / l3 * l3 + l;
        }
        return () -> new PrimitiveIterator.OfLong(){
            private long next;
            private boolean running;
            {
                this.next = l;
                this.running = true;
            }

            @Override
            public long nextLong() {
                if (!this.running) {
                    throw new NoSuchElementException("Iterator was already at its end!");
                }
                long l2 = this.next;
                if (l2 == l4) {
                    this.running = false;
                } else {
                    this.next += l3;
                }
                return l2;
            }

            @Override
            public boolean hasNext() {
                return this.running;
            }
        };
    }

    @NotNull
    public static PrimitiveLongIterable of(long l, long l2) {
        return l <= l2 ? Range.of(l, l2, 1L) : Range.of(l, l2, -1L);
    }

    @NotNull
    public static PrimitiveIntIterable indexes(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("Length must not be negative!");
        }
        return n != 0 ? Range.of(0, n - 1) : PrimitiveIntIterable.EMPTY;
    }

    @NotNull
    public static PrimitiveIntIterable indexes(@NotNull Object[] objectArray) {
        return Range.indexes(objectArray.length);
    }

    @NotNull
    public static PrimitiveIntIterable indexes(@NotNull Collection<?> collection) {
        return Range.indexes(collection.size());
    }

    @NotNull
    public static PrimitiveIntIterable indexes(@NotNull Sizeable sizeable) {
        return Range.indexes(sizeable.size());
    }
}

