/*
 * Decompiled with CFR 0.152.
 */
package de.caff.generics.mda;

import de.caff.annotation.NotNull;
import de.caff.generics.function.IntToShortFunction2;
import de.caff.generics.mda.TwoDimensionalShortAccess;
import de.caff.generics.mda.TwoDimensionalShortReadAccess;

public class TwoDimensionalShortArray
extends TwoDimensionalShortReadAccess.Base
implements TwoDimensionalShortAccess {
    @NotNull
    private final short[][] values;

    public TwoDimensionalShortArray(int n, int n2) {
        this.values = new short[n][n2];
    }

    public TwoDimensionalShortArray(int n, int n2, @NotNull IntToShortFunction2 intToShortFunction2) {
        this(n, n2);
        this.fillValuesByIndex(intToShortFunction2);
    }

    public TwoDimensionalShortArray(int n, short ... sArray) {
        if (n <= 0 || sArray.length == 0) {
            throw new IllegalArgumentException("Need positive sizes!");
        }
        if (sArray.length % n != 0) {
            throw new IllegalArgumentException("Need a multiple of ySize values!");
        }
        this.values = new short[sArray.length / n][n];
        for (int i = 0; i < sArray.length; ++i) {
            this.values[i / n][i % n] = sArray[i];
        }
    }

    @Override
    public void setValueAt(short s, int n, int n2) {
        this.values[n][n2] = s;
    }

    @Override
    public short getValueAt(int n, int n2) {
        return this.values[n][n2];
    }

    @Override
    public int sizeX() {
        return this.values.length;
    }

    @Override
    public int sizeY() {
        return this.values[0].length;
    }
}

